/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.IDataInput;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;

class ChunkMetadata {
    static final long METADATA_EVENT_TYPE = 0L;
    private static final String VALUE = "value";

    ChunkMetadata() {
    }

    static RootElement readMetadata(IDataInput input) throws IOException, InvalidJfrFileException {
        input.readInt();
        ParserToolkit.assertValue(input.readLong(), 0L);
        input.readLong();
        input.readLong();
        input.readLong();
        int stringCount = input.readInt();
        String[] strings = new String[stringCount];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = input.readRawString(input.readByte());
        }
        int nameIndex = input.readInt();
        if (!"root".equals(strings[nameIndex])) {
            Logger.getLogger(ChunkMetadata.class.getName()).log(Level.WARNING, "Expected metadata root element to be named root, but it was named " + strings[nameIndex] + ". If the metadata parsing fails in a later stage, this might be the cause.");
        }
        RootElement rootElement = new RootElement();
        ChunkMetadata.loadElement(input, strings, rootElement);
        return rootElement;
    }

    private static void loadElement(IDataInput in, String[] s, IElement element) throws IOException, InvalidJfrFileException {
        int attributeCount = in.readInt();
        for (int i = 0; i < attributeCount; ++i) {
            int key = in.readInt();
            int value = in.readInt();
            element.setAttribute(s[key], s[value]);
        }
        int elementCount = in.readInt();
        for (int i = 0; i < elementCount; ++i) {
            int nameIndex = in.readInt();
            IElement child = element.appendChild(s[nameIndex]);
            if (child == null) {
                throw new InvalidJfrFileException("Did not expect a child of " + element.getClass().getSimpleName() + " with name '" + s[nameIndex] + "'.");
            }
            ChunkMetadata.loadElement(in, s, child);
        }
    }

    static class RegionElement
    implements IElement {
        RegionElement() {
        }

        @Override
        public void setAttribute(String attribute, String value) {
        }

        @Override
        public IElement appendChild(String child) {
            return null;
        }
    }

    static class FieldElement
    extends AnnotatedElement {
        private static final String ANNOTATION_TIMESTAMP = "jdk.jfr.Timestamp";
        private static final String ANNOTATION_TIMESPAN = "jdk.jfr.Timespan";
        private static final String ANNOTATION_MEMORY_ADDRESS = "jdk.jfr.MemoryAddress";
        private static final String ANNOTATION_PERCENTAGE = "jdk.jfr.Percentage";
        private static final String ANNOTATION_MEMORY_AMOUNT = "jdk.jfr.MemoryAmount";
        private static final String ANNOTATION_DATA_AMOUNT = "jdk.jfr.DataAmount";
        private static final String ANNOTATION_UNSIGNED = "jdk.jfr.Unsigned";
        private static final String UNIT_S = "SECONDS";
        private static final String UNIT_MS = "MILLISECONDS";
        private static final String UNIT_NS = "NANOSECONDS";
        private static final String UNIT_TICKS = "TICKS";
        private static final String UNIT_S_SINCE_EPOCH = "SECONDS_SINCE_EPOCH";
        private static final String UNIT_MS_SINCE_EPOCH = "MILLISECONDS_SINCE_EPOCH";
        private static final String UNIT_NS_SINCE_EPOCH = "NANOSECONDS_SINCE_EPOCH";
        String fieldIdentifier;
        long classId;
        Boolean constantPool;
        Integer dimension;
        IUnit unit;
        KindOfQuantity<?> ticksUnitKind;
        boolean unsigned;

        FieldElement() {
        }

        @Override
        public void setAttribute(String attribute, String value) {
            switch (attribute) {
                case "name": {
                    this.fieldIdentifier = value;
                    break;
                }
                case "class": {
                    this.classId = Long.parseLong(value);
                    break;
                }
                case "constantPool": {
                    this.constantPool = Boolean.parseBoolean(value);
                    break;
                }
                case "dimension": {
                    this.dimension = Integer.parseInt(value);
                    break;
                }
            }
        }

        @Override
        public IElement appendChild(String childName) {
            return super.appendChild(childName);
        }

        @Override
        void resolveAnnotation(String typeIdentifier, Map<String, String> values) throws InvalidJfrFileException {
            switch (typeIdentifier) {
                case "jdk.jfr.Unsigned": {
                    this.unsigned = true;
                    return;
                }
                case "jdk.jfr.MemoryAmount": 
                case "jdk.jfr.DataAmount": {
                    this.unit = UnitLookup.BYTE;
                    return;
                }
                case "jdk.jfr.Percentage": {
                    this.unit = UnitLookup.PERCENT_UNITY;
                    return;
                }
                case "jdk.jfr.MemoryAddress": {
                    this.unit = UnitLookup.ADDRESS_UNITY;
                    return;
                }
                case "jdk.jfr.Timespan": {
                    String unitId;
                    switch (unitId = values.get(ChunkMetadata.VALUE)) {
                        case "TICKS": {
                            this.ticksUnitKind = UnitLookup.TIMESPAN;
                            return;
                        }
                        case "NANOSECONDS": {
                            this.unit = UnitLookup.NANOSECOND;
                            return;
                        }
                        case "MILLISECONDS": {
                            this.unit = UnitLookup.MILLISECOND;
                            return;
                        }
                        case "SECONDS": {
                            this.unit = UnitLookup.SECOND;
                            return;
                        }
                    }
                    return;
                }
                case "jdk.jfr.Timestamp": {
                    String unitId;
                    switch (unitId = values.get(ChunkMetadata.VALUE)) {
                        case "TICKS": {
                            this.ticksUnitKind = UnitLookup.TIMESTAMP;
                            return;
                        }
                        case "NANOSECONDS_SINCE_EPOCH": {
                            this.unit = UnitLookup.EPOCH_NS;
                            return;
                        }
                        case "MILLISECONDS_SINCE_EPOCH": {
                            this.unit = UnitLookup.EPOCH_MS;
                            return;
                        }
                        case "SECONDS_SINCE_EPOCH": {
                            this.unit = UnitLookup.EPOCH_S;
                            return;
                        }
                    }
                    return;
                }
            }
            super.resolveAnnotation(typeIdentifier, values);
        }

        boolean isStoredInPool() {
            return this.constantPool != null && this.constantPool != false;
        }

        boolean isArray() throws InvalidJfrFileException {
            if (this.dimension == null || this.dimension == 0) {
                return false;
            }
            if (this.dimension == 1) {
                return true;
            }
            throw new InvalidJfrFileException("Array dimension " + this.dimension + " is not supported");
        }
    }

    static class SettingElement
    extends AnnotatedElement {
        SettingElement() {
        }

        @Override
        public void setAttribute(String attribute, String value) {
        }
    }

    static class AnnotationElement
    implements IElement {
        long classId;
        Map<String, String> values;

        AnnotationElement() {
        }

        @Override
        public void setAttribute(String attribute, String value) {
            switch (attribute) {
                case "class": {
                    this.classId = Long.parseLong(value);
                    break;
                }
                default: {
                    if (this.values == null) {
                        this.values = new HashMap<String, String>();
                    }
                    this.values.put(attribute, value);
                }
            }
        }

        @Override
        public IElement appendChild(String child) {
            return null;
        }
    }

    static class ClassElement
    extends AnnotatedElement {
        private static final String ANNOTATION_CATEGORY = "jdk.jfr.Category";
        private static final String SUPER_TYPE_EVENT = "jdk.jfr.Event";
        long classId;
        String typeIdentifier;
        String superType;
        Boolean simpleType;
        List<FieldElement> fields;
        private SettingElement ignored;
        String[] category;

        ClassElement() {
        }

        @Override
        public void setAttribute(String attribute, String value) {
            switch (attribute) {
                case "id": {
                    this.classId = Long.parseLong(value);
                    break;
                }
                case "name": {
                    this.typeIdentifier = value;
                    break;
                }
                case "superType": {
                    this.superType = value;
                    break;
                }
                case "simpleType": {
                    this.simpleType = Boolean.parseBoolean(value);
                    break;
                }
            }
        }

        @Override
        public IElement appendChild(String childName) {
            switch (childName) {
                case "field": {
                    if (this.fields == null) {
                        this.fields = new ArrayList<FieldElement>();
                    }
                    FieldElement field = new FieldElement();
                    this.fields.add(field);
                    return field;
                }
                case "setting": {
                    if (this.ignored == null) {
                        this.ignored = new SettingElement();
                    }
                    return this.ignored;
                }
            }
            return super.appendChild(childName);
        }

        @Override
        void resolveAnnotation(String typeIdentifier, Map<String, String> values) throws InvalidJfrFileException {
            switch (typeIdentifier) {
                case "jdk.jfr.Category": {
                    String s;
                    ArrayList<String> list = new ArrayList<String>();
                    int index = 0;
                    while ((s = values.get("value-" + index++)) != null) {
                        list.add(s);
                    }
                    this.category = list.toArray(new String[list.size()]);
                    return;
                }
            }
            super.resolveAnnotation(typeIdentifier, values);
        }

        int getFieldCount() {
            return this.fields == null ? 0 : this.fields.size();
        }

        boolean isSimpleType() {
            return this.simpleType != null && this.simpleType != false;
        }

        boolean isEventType() {
            return SUPER_TYPE_EVENT.equals(this.superType);
        }
    }

    static class AnnotatedElement
    implements IElement {
        private static final String ANNOTATION_DESCRIPTION = "jdk.jfr.Description";
        private static final String ANNOTATION_LABEL = "jdk.jfr.Label";
        private static final String ANNOTATION_EXPERIMENTAL = "jdk.jfr.Experimental";
        List<AnnotationElement> annotations;
        String label;
        String description;
        boolean experimental;

        AnnotatedElement() {
        }

        void resolveAnnotation(String typeIdentifier, Map<String, String> values) throws InvalidJfrFileException {
            switch (typeIdentifier) {
                case "jdk.jfr.Label": {
                    this.label = values.get(ChunkMetadata.VALUE);
                    return;
                }
                case "jdk.jfr.Description": {
                    this.description = values.get(ChunkMetadata.VALUE);
                    return;
                }
                case "jdk.jfr.Experimental": {
                    this.experimental = true;
                    return;
                }
            }
        }

        @Override
        public void setAttribute(String attribute, String value) {
        }

        @Override
        public IElement appendChild(String childName) {
            switch (childName) {
                case "annotation": {
                    if (this.annotations == null) {
                        this.annotations = new ArrayList<AnnotationElement>();
                    }
                    AnnotationElement child = new AnnotationElement();
                    this.annotations.add(child);
                    return child;
                }
            }
            return null;
        }
    }

    static class MetadataElement
    implements IElement {
        List<ClassElement> classes;

        MetadataElement() {
        }

        @Override
        public void setAttribute(String attribute, String value) {
        }

        @Override
        public IElement appendChild(String childName) {
            switch (childName) {
                case "class": {
                    if (this.classes == null) {
                        this.classes = new ArrayList<ClassElement>();
                    }
                    ClassElement child = new ClassElement();
                    this.classes.add(child);
                    return child;
                }
            }
            return null;
        }
    }

    static class RootElement
    implements IElement {
        MetadataElement metadata;
        RegionElement region;

        RootElement() {
        }

        @Override
        public void setAttribute(String attribute, String value) {
        }

        @Override
        public IElement appendChild(String childName) {
            switch (childName) {
                case "metadata": {
                    this.metadata = new MetadataElement();
                    return this.metadata;
                }
                case "region": {
                    this.region = new RegionElement();
                    return this.region;
                }
            }
            return null;
        }
    }

    private static interface IElement {
        public void setAttribute(String var1, String var2);

        public IElement appendChild(String var1);
    }
}

