/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jersey3;

import com.codahale.metrics.Clock;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@Provider
public class InstrumentedResourceMethodApplicationListener
implements ApplicationEventListener,
ModelProcessor {
    private static final String[] REQUEST_FILTERING = new String[]{"request", "filtering"};
    private static final String[] RESPONSE_FILTERING = new String[]{"response", "filtering"};
    private static final String TOTAL = "total";
    private final MetricRegistry metrics;
    private final ConcurrentMap<EventTypeAndMethod, Timer> timers = new ConcurrentHashMap<EventTypeAndMethod, Timer>();
    private final ConcurrentMap<Method, Meter> meters = new ConcurrentHashMap<Method, Meter>();
    private final ConcurrentMap<Method, ExceptionMeterMetric> exceptionMeters = new ConcurrentHashMap<Method, ExceptionMeterMetric>();
    private final ConcurrentMap<Method, ResponseMeterMetric> responseMeters = new ConcurrentHashMap<Method, ResponseMeterMetric>();
    private final Clock clock;
    private final boolean trackFilters;
    private final Supplier<Reservoir> reservoirSupplier;

    public InstrumentedResourceMethodApplicationListener(MetricRegistry metrics) {
        this(metrics, Clock.defaultClock(), false);
    }

    public InstrumentedResourceMethodApplicationListener(MetricRegistry metrics, Clock clock, boolean trackFilters) {
        this(metrics, clock, trackFilters, ExponentiallyDecayingReservoir::new);
    }

    public InstrumentedResourceMethodApplicationListener(MetricRegistry metrics, Clock clock, boolean trackFilters, Supplier<Reservoir> reservoirSupplier) {
        this.metrics = metrics;
        this.clock = clock;
        this.trackFilters = trackFilters;
        this.reservoirSupplier = reservoirSupplier;
    }

    public void onEvent(ApplicationEvent event) {
        if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
            this.registerMetricsForModel(event.getResourceModel());
        }
    }

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        return resourceModel;
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        this.registerMetricsForModel(subResourceModel);
        return subResourceModel;
    }

    private void registerMetricsForModel(ResourceModel resourceModel) {
        for (Resource resource : resourceModel.getResources()) {
            Timed classLevelTimed = this.getClassLevelAnnotation(resource, Timed.class);
            Metered classLevelMetered = this.getClassLevelAnnotation(resource, Metered.class);
            ExceptionMetered classLevelExceptionMetered = this.getClassLevelAnnotation(resource, ExceptionMetered.class);
            ResponseMetered classLevelResponseMetered = this.getClassLevelAnnotation(resource, ResponseMetered.class);
            for (ResourceMethod method : resource.getAllMethods()) {
                this.registerTimedAnnotations(method, classLevelTimed);
                this.registerMeteredAnnotations(method, classLevelMetered);
                this.registerExceptionMeteredAnnotations(method, classLevelExceptionMetered);
                this.registerResponseMeteredAnnotations(method, classLevelResponseMetered);
            }
            for (Resource childResource : resource.getChildResources()) {
                Timed classLevelTimedChild = this.getClassLevelAnnotation(childResource, Timed.class);
                Metered classLevelMeteredChild = this.getClassLevelAnnotation(childResource, Metered.class);
                ExceptionMetered classLevelExceptionMeteredChild = this.getClassLevelAnnotation(childResource, ExceptionMetered.class);
                ResponseMetered classLevelResponseMeteredChild = this.getClassLevelAnnotation(childResource, ResponseMetered.class);
                for (ResourceMethod method : childResource.getAllMethods()) {
                    this.registerTimedAnnotations(method, classLevelTimedChild);
                    this.registerMeteredAnnotations(method, classLevelMeteredChild);
                    this.registerExceptionMeteredAnnotations(method, classLevelExceptionMeteredChild);
                    this.registerResponseMeteredAnnotations(method, classLevelResponseMeteredChild);
                }
            }
        }
    }

    public RequestEventListener onRequest(RequestEvent event) {
        ChainedRequestEventListener listener = new ChainedRequestEventListener(new RequestEventListener[]{new TimerRequestEventListener(this.timers, this.clock), new MeterRequestEventListener(this.meters), new ExceptionMeterRequestEventListener(this.exceptionMeters), new ResponseMeterRequestEventListener(this.responseMeters)});
        return listener;
    }

    private <T extends Annotation> T getClassLevelAnnotation(Resource resource, Class<T> annotationClazz) {
        Class clazz;
        T annotation = null;
        Iterator iterator = resource.getHandlerClasses().iterator();
        while (iterator.hasNext() && (annotation = (T)(clazz = (Class)iterator.next()).getAnnotation(annotationClazz)) == null) {
        }
        return annotation;
    }

    private void registerTimedAnnotations(ResourceMethod method, Timed classLevelTimed) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (classLevelTimed != null) {
            this.registerTimers(method, definitionMethod, classLevelTimed);
            return;
        }
        Timed annotation = definitionMethod.getAnnotation(Timed.class);
        if (annotation != null) {
            this.registerTimers(method, definitionMethod, annotation);
        }
    }

    private void registerTimers(ResourceMethod method, Method definitionMethod, Timed annotation) {
        this.timers.putIfAbsent(EventTypeAndMethod.requestMethodStart(definitionMethod), this.timerMetric(this.metrics, method, annotation, new String[0]));
        if (this.trackFilters) {
            this.timers.putIfAbsent(EventTypeAndMethod.requestMatched(definitionMethod), this.timerMetric(this.metrics, method, annotation, REQUEST_FILTERING));
            this.timers.putIfAbsent(EventTypeAndMethod.respFiltersStart(definitionMethod), this.timerMetric(this.metrics, method, annotation, RESPONSE_FILTERING));
            this.timers.putIfAbsent(EventTypeAndMethod.finished(definitionMethod), this.timerMetric(this.metrics, method, annotation, TOTAL));
        }
    }

    private void registerMeteredAnnotations(ResourceMethod method, Metered classLevelMetered) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (classLevelMetered != null) {
            this.meters.putIfAbsent(definitionMethod, this.meterMetric(this.metrics, method, classLevelMetered));
            return;
        }
        Metered annotation = definitionMethod.getAnnotation(Metered.class);
        if (annotation != null) {
            this.meters.putIfAbsent(definitionMethod, this.meterMetric(this.metrics, method, annotation));
        }
    }

    private void registerExceptionMeteredAnnotations(ResourceMethod method, ExceptionMetered classLevelExceptionMetered) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (classLevelExceptionMetered != null) {
            this.exceptionMeters.putIfAbsent(definitionMethod, new ExceptionMeterMetric(this.metrics, method, classLevelExceptionMetered));
            return;
        }
        ExceptionMetered annotation = definitionMethod.getAnnotation(ExceptionMetered.class);
        if (annotation != null) {
            this.exceptionMeters.putIfAbsent(definitionMethod, new ExceptionMeterMetric(this.metrics, method, annotation));
        }
    }

    private void registerResponseMeteredAnnotations(ResourceMethod method, ResponseMetered classLevelResponseMetered) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (classLevelResponseMetered != null) {
            this.responseMeters.putIfAbsent(definitionMethod, new ResponseMeterMetric(this.metrics, method, classLevelResponseMetered));
            return;
        }
        ResponseMetered annotation = definitionMethod.getAnnotation(ResponseMetered.class);
        if (annotation != null) {
            this.responseMeters.putIfAbsent(definitionMethod, new ResponseMeterMetric(this.metrics, method, annotation));
        }
    }

    private Timer timerMetric(MetricRegistry registry, ResourceMethod method, Timed timed, String ... suffixes) {
        String name = InstrumentedResourceMethodApplicationListener.chooseName(timed.name(), timed.absolute(), method, suffixes);
        return registry.timer(name, () -> new Timer(this.reservoirSupplier.get(), this.clock));
    }

    private Meter meterMetric(MetricRegistry registry, ResourceMethod method, Metered metered) {
        String name = InstrumentedResourceMethodApplicationListener.chooseName(metered.name(), metered.absolute(), method, new String[0]);
        return registry.meter(name, () -> new Meter(this.clock));
    }

    protected static String chooseName(String explicitName, boolean absolute, ResourceMethod method, String ... suffixes) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        String metricName = explicitName != null && !explicitName.isEmpty() ? (absolute ? explicitName : MetricRegistry.name(definitionMethod.getDeclaringClass(), (String[])new String[]{explicitName})) : MetricRegistry.name(definitionMethod.getDeclaringClass(), (String[])new String[]{definitionMethod.getName()});
        return MetricRegistry.name((String)metricName, (String[])suffixes);
    }

    private static class EventTypeAndMethod {
        private final RequestEvent.Type type;
        private final Method method;

        private EventTypeAndMethod(RequestEvent.Type type, Method method) {
            this.type = type;
            this.method = method;
        }

        static EventTypeAndMethod requestMethodStart(Method method) {
            return new EventTypeAndMethod(RequestEvent.Type.RESOURCE_METHOD_START, method);
        }

        static EventTypeAndMethod requestMatched(Method method) {
            return new EventTypeAndMethod(RequestEvent.Type.REQUEST_MATCHED, method);
        }

        static EventTypeAndMethod respFiltersStart(Method method) {
            return new EventTypeAndMethod(RequestEvent.Type.RESP_FILTERS_START, method);
        }

        static EventTypeAndMethod finished(Method method) {
            return new EventTypeAndMethod(RequestEvent.Type.FINISHED, method);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventTypeAndMethod that = (EventTypeAndMethod)o;
            if (this.type != that.type) {
                return false;
            }
            return this.method.equals(that.method);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.method.hashCode();
            return result;
        }
    }

    private static class ChainedRequestEventListener
    implements RequestEventListener {
        private final RequestEventListener[] listeners;

        private ChainedRequestEventListener(RequestEventListener ... listeners) {
            this.listeners = listeners;
        }

        public void onEvent(RequestEvent event) {
            for (RequestEventListener listener : this.listeners) {
                listener.onEvent(event);
            }
        }
    }

    private static class ResponseMeterRequestEventListener
    implements RequestEventListener {
        private final ConcurrentMap<Method, ResponseMeterMetric> responseMeters;

        public ResponseMeterRequestEventListener(ConcurrentMap<Method, ResponseMeterMetric> responseMeters) {
            this.responseMeters = responseMeters;
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.FINISHED) {
                ResponseMeterMetric metric;
                ResourceMethod method = event.getUriInfo().getMatchedResourceMethod();
                ResponseMeterMetric responseMeterMetric = metric = method != null ? (ResponseMeterMetric)this.responseMeters.get(method.getInvocable().getDefinitionMethod()) : null;
                if (metric != null) {
                    ContainerResponse containerResponse = event.getContainerResponse();
                    if (containerResponse == null) {
                        if (event.getException() != null) {
                            metric.meters.get(4).mark();
                        }
                    } else {
                        int responseStatus = containerResponse.getStatus() / 100;
                        if (responseStatus >= 1 && responseStatus <= 5) {
                            metric.meters.get(responseStatus - 1).mark();
                        }
                    }
                }
            }
        }
    }

    private static class ExceptionMeterRequestEventListener
    implements RequestEventListener {
        private final ConcurrentMap<Method, ExceptionMeterMetric> exceptionMeters;

        public ExceptionMeterRequestEventListener(ConcurrentMap<Method, ExceptionMeterMetric> exceptionMeters) {
            this.exceptionMeters = exceptionMeters;
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.ON_EXCEPTION) {
                ExceptionMeterMetric metric;
                ResourceMethod method = event.getUriInfo().getMatchedResourceMethod();
                ExceptionMeterMetric exceptionMeterMetric = metric = method != null ? (ExceptionMeterMetric)this.exceptionMeters.get(method.getInvocable().getDefinitionMethod()) : null;
                if (metric != null && (metric.cause.isAssignableFrom(event.getException().getClass()) || event.getException().getCause() != null && metric.cause.isAssignableFrom(event.getException().getCause().getClass()))) {
                    metric.meter.mark();
                }
            }
        }
    }

    private static class MeterRequestEventListener
    implements RequestEventListener {
        private final ConcurrentMap<Method, Meter> meters;

        public MeterRequestEventListener(ConcurrentMap<Method, Meter> meters) {
            this.meters = meters;
        }

        public void onEvent(RequestEvent event) {
            Meter meter;
            if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_START && (meter = (Meter)this.meters.get(event.getUriInfo().getMatchedResourceMethod().getInvocable().getDefinitionMethod())) != null) {
                meter.mark();
            }
        }
    }

    private static class TimerRequestEventListener
    implements RequestEventListener {
        private final ConcurrentMap<EventTypeAndMethod, Timer> timers;
        private final Clock clock;
        private final long start;
        private Timer.Context resourceMethodStartContext;
        private Timer.Context requestMatchedContext;
        private Timer.Context responseFiltersStartContext;

        public TimerRequestEventListener(ConcurrentMap<EventTypeAndMethod, Timer> timers, Clock clock) {
            this.timers = timers;
            this.clock = clock;
            this.start = clock.getTick();
        }

        public void onEvent(RequestEvent event) {
            switch (event.getType()) {
                case RESOURCE_METHOD_START: {
                    this.resourceMethodStartContext = this.context(event);
                    break;
                }
                case REQUEST_MATCHED: {
                    this.requestMatchedContext = this.context(event);
                    break;
                }
                case RESP_FILTERS_START: {
                    this.responseFiltersStartContext = this.context(event);
                    break;
                }
                case RESOURCE_METHOD_FINISHED: {
                    if (this.resourceMethodStartContext == null) break;
                    this.resourceMethodStartContext.close();
                    break;
                }
                case REQUEST_FILTERED: {
                    if (this.requestMatchedContext == null) break;
                    this.requestMatchedContext.close();
                    break;
                }
                case RESP_FILTERS_FINISHED: {
                    if (this.responseFiltersStartContext == null) break;
                    this.responseFiltersStartContext.close();
                    break;
                }
                case FINISHED: {
                    Timer timer;
                    if (this.requestMatchedContext == null || this.responseFiltersStartContext == null || (timer = this.timer(event)) == null) break;
                    timer.update(this.clock.getTick() - this.start, TimeUnit.NANOSECONDS);
                    break;
                }
            }
        }

        private Timer timer(RequestEvent event) {
            ResourceMethod resourceMethod = event.getUriInfo().getMatchedResourceMethod();
            if (resourceMethod == null) {
                return null;
            }
            return (Timer)this.timers.get(new EventTypeAndMethod(event.getType(), resourceMethod.getInvocable().getDefinitionMethod()));
        }

        private Timer.Context context(RequestEvent event) {
            Timer timer = this.timer(event);
            return timer != null ? timer.time() : null;
        }
    }

    private static class ResponseMeterMetric {
        public final List<Meter> meters;

        public ResponseMeterMetric(MetricRegistry registry, ResourceMethod method, ResponseMetered responseMetered) {
            String metricName = InstrumentedResourceMethodApplicationListener.chooseName(responseMetered.name(), responseMetered.absolute(), method, new String[0]);
            this.meters = Collections.unmodifiableList(Arrays.asList(registry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"1xx-responses"})), registry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"2xx-responses"})), registry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"3xx-responses"})), registry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"4xx-responses"})), registry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"5xx-responses"}))));
        }
    }

    private static class ExceptionMeterMetric {
        public final Meter meter;
        public final Class<? extends Throwable> cause;

        public ExceptionMeterMetric(MetricRegistry registry, ResourceMethod method, ExceptionMetered exceptionMetered) {
            String name = InstrumentedResourceMethodApplicationListener.chooseName(exceptionMetered.name(), exceptionMetered.absolute(), method, "exceptions");
            this.meter = registry.meter(name);
            this.cause = exceptionMetered.cause();
        }
    }
}

