/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class LlcControlModifierFunction
extends NamedNumber<Byte, LlcControlModifierFunction> {
    private static final long serialVersionUID = 468392162004904375L;
    public static final LlcControlModifierFunction UI = new LlcControlModifierFunction((byte)0, "UI");
    public static final LlcControlModifierFunction DM = new LlcControlModifierFunction((byte)3, "DM");
    public static final LlcControlModifierFunction DISC = new LlcControlModifierFunction((byte)16, "DISC");
    public static final LlcControlModifierFunction UA = new LlcControlModifierFunction((byte)24, "UA");
    public static final LlcControlModifierFunction AC0 = new LlcControlModifierFunction((byte)25, "AC0");
    public static final LlcControlModifierFunction SABME = new LlcControlModifierFunction((byte)27, "SABME");
    public static final LlcControlModifierFunction FRMR = new LlcControlModifierFunction((byte)33, "FRMR");
    public static final LlcControlModifierFunction XID = new LlcControlModifierFunction((byte)43, "XID");
    public static final LlcControlModifierFunction TEST = new LlcControlModifierFunction((byte)56, "TEST");
    public static final LlcControlModifierFunction AC1 = new LlcControlModifierFunction((byte)57, "AC1");
    private static final Map<Byte, LlcControlModifierFunction> registry = new HashMap<Byte, LlcControlModifierFunction>();

    public LlcControlModifierFunction(Byte value, String name) {
        super(value, name);
        if (value < 0 || value > 59 || (value & 4) != 0) {
            throw new IllegalArgumentException("value must be (value >= 0 || value <= 55 || (value & 0x04) == 0). value: " + value);
        }
    }

    public static LlcControlModifierFunction getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new LlcControlModifierFunction(value, "unknown");
    }

    public static LlcControlModifierFunction register(LlcControlModifierFunction number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(LlcControlModifierFunction o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        registry.put((Byte)UI.value(), UI);
        registry.put((Byte)DM.value(), DM);
        registry.put((Byte)DISC.value(), DISC);
        registry.put((Byte)UA.value(), UA);
        registry.put((Byte)AC0.value(), AC0);
        registry.put((Byte)SABME.value(), SABME);
        registry.put((Byte)FRMR.value(), FRMR);
        registry.put((Byte)XID.value(), XID);
        registry.put((Byte)TEST.value(), TEST);
        registry.put((Byte)AC1.value(), AC1);
    }
}

