/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.subject.creater;

import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectCreate;
import com.usthe.sureness.subject.support.DigestSubject;
import com.usthe.sureness.util.ServletUtil;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestSubjectServletCreator
implements SubjectCreate {
    private static final Logger logger = LoggerFactory.getLogger(DigestSubjectServletCreator.class);
    private static final String USERNAME = "username";
    private static final String NONCE = "nonce";
    private static final String QOP = "qop";
    private static final String REALM = "realm";
    private static final String NC = "nc";
    private static final String CNONCE = "cnonce";
    private static final String RESPONSE = "response";
    private static final String URI = "uri";
    private static final int FILED_SIZE = 2;
    private static final String SPLIT = "\"";

    @Override
    public boolean canSupportSubject(Object context) {
        if (context instanceof HttpServletRequest) {
            String authorization = ((HttpServletRequest)context).getHeader("Authorization");
            return authorization == null || authorization.startsWith("Digest ");
        }
        return false;
    }

    @Override
    public Subject createSubject(Object context) {
        String authorization = ((HttpServletRequest)context).getHeader("Authorization");
        if (authorization == null) {
            return new DigestSubject();
        }
        String digestAuth = authorization.replace("Digest ", "").trim();
        try {
            HashMap digestMap = new HashMap(8);
            Arrays.stream(digestAuth.split(",")).forEach(auth -> {
                String[] tmpArr = auth.trim().split("=");
                if (tmpArr.length == 2) {
                    String authValue = tmpArr[1].trim();
                    if (authValue.startsWith(SPLIT) && authValue.endsWith(SPLIT)) {
                        authValue = authValue.substring(1, authValue.length() - 1);
                    }
                    digestMap.put(tmpArr[0].trim(), authValue);
                }
            });
            String username = (String)digestMap.get(USERNAME);
            String response = (String)digestMap.get(RESPONSE);
            String realm = (String)digestMap.get(REALM);
            String uri = (String)digestMap.get(URI);
            String nonce = (String)digestMap.get(NONCE);
            String nc = (String)digestMap.get(NC);
            String cNonce = (String)digestMap.get(CNONCE);
            String qop = (String)digestMap.get(QOP);
            if (username == null || response == null || realm == null || uri == null || nonce == null || nc == null || cNonce == null) {
                logger.debug("can not create digest subject due some need field is null");
                return null;
            }
            String remoteHost = ((HttpServletRequest)context).getRemoteHost();
            String requestUri = ServletUtil.getRequestUri((HttpServletRequest)context);
            String requestType = ((HttpServletRequest)context).getMethod();
            String targetUri = requestUri.concat("===").concat(requestType).toLowerCase();
            return DigestSubject.builder(username, response).setRealm(realm).setUri(uri).setNonce(nonce).setNc(nc).setCnonce(cNonce).setQop(qop).setHttpMethod(requestType.toUpperCase()).setRemoteHost(remoteHost).setTargetUri(targetUri).build();
        }
        catch (Exception e) {
            logger.info("create digest subject error happen, due {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

