/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Objects;
import org.apache.hertzbeat.alert.service.AlertDefineService;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Alert Define API")
@RestController
@RequestMapping(path={"/api/alert/define"}, produces={"application/json"})
public class AlertDefineController {
    @Autowired
    private AlertDefineService alertDefineService;

    @PostMapping
    @Operation(summary="New Alarm Definition", description="Added an alarm definition")
    public ResponseEntity<Message<Void>> addNewAlertDefine(@Valid @RequestBody AlertDefine alertDefine) {
        this.alertDefineService.validate(alertDefine, false);
        this.alertDefineService.addAlertDefine(alertDefine);
        return ResponseEntity.ok((Object)Message.success((String)"Add success"));
    }

    @PutMapping
    @Operation(summary="Modifying an Alarm Definition", description="Modify an existing alarm definition")
    public ResponseEntity<Message<Void>> modifyAlertDefine(@Valid @RequestBody AlertDefine alertDefine) {
        this.alertDefineService.validate(alertDefine, true);
        this.alertDefineService.modifyAlertDefine(alertDefine);
        return ResponseEntity.ok((Object)Message.success((String)"Modify success"));
    }

    @GetMapping(path={"/{id}"})
    @Operation(summary="Querying Alarm Definitions", description="You can obtain alarm definition information based on the alarm definition ID")
    public ResponseEntity<Message<AlertDefine>> getAlertDefine(@Parameter(description="Alarm Definition ID", example="6565463543") @PathVariable(value="id") long id) {
        AlertDefine alertDefine = this.alertDefineService.getAlertDefine(id);
        return Objects.isNull(alertDefine) ? ResponseEntity.ok((Object)Message.fail((byte)3, (String)"AlertDefine not exist.")) : ResponseEntity.ok((Object)Message.success((Object)alertDefine));
    }

    @DeleteMapping(path={"/{id}"})
    @Operation(summary="Deleting an Alarm Definition", description="If the alarm definition does not exist, the alarm is deleted successfully")
    public ResponseEntity<Message<Void>> deleteAlertDefine(@Parameter(description="Alarm Definition ID", example="6565463543") @PathVariable(value="id") long id) {
        this.alertDefineService.deleteAlertDefine(id);
        return ResponseEntity.ok((Object)Message.success((String)"Delete success"));
    }
}

