/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.realtime.redis.client;

import io.lettuce.core.codec.RedisCodec;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.serialize.RedisMetricsDataCodec;
import org.apache.hertzbeat.warehouse.store.realtime.redis.RedisProperties;
import org.apache.hertzbeat.warehouse.store.realtime.redis.client.RedisClientOperation;
import org.apache.hertzbeat.warehouse.store.realtime.redis.client.impl.RedisClusterClientImpl;
import org.apache.hertzbeat.warehouse.store.realtime.redis.client.impl.RedisSentinelClientImpl;
import org.apache.hertzbeat.warehouse.store.realtime.redis.client.impl.RedisSimpleClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCommandDelegate {
    private static final Logger log = LoggerFactory.getLogger(RedisCommandDelegate.class);
    private static final String SINGLE_MODE = "single";
    private static final String SENTINEL_MODE = "sentinel";
    private static final String CLUSTER_MODE = "cluster";
    private static final RedisCommandDelegate INSTANCE = new RedisCommandDelegate();
    private RedisClientOperation<String, CollectRep.MetricsData> operation;

    public static RedisCommandDelegate getInstance() {
        return INSTANCE;
    }

    public RedisClientOperation<String, CollectRep.MetricsData> operate() {
        return this.operation;
    }

    public void destroy() throws Exception {
        this.operation.close();
    }

    public boolean initRedisClient(RedisProperties redisProperties) {
        if (redisProperties == null) {
            log.error("init error, please config Warehouse redis props in application.yml");
            return false;
        }
        try {
            this.operation = switch (redisProperties.mode()) {
                case SINGLE_MODE -> new RedisSimpleClientImpl().connect(redisProperties, (RedisCodec<String, CollectRep.MetricsData>)new RedisMetricsDataCodec());
                case SENTINEL_MODE -> new RedisSentinelClientImpl().connect(redisProperties, (RedisCodec<String, CollectRep.MetricsData>)new RedisMetricsDataCodec());
                case CLUSTER_MODE -> new RedisClusterClientImpl().connect(redisProperties, (RedisCodec<String, CollectRep.MetricsData>)new RedisMetricsDataCodec());
                default -> throw new UnsupportedOperationException("Incorrect redis mode: " + redisProperties.mode());
            };
            return true;
        }
        catch (Exception e) {
            log.error("init redis error {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private RedisCommandDelegate() {
    }
}

