/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.util.json;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import java.io.IOException;
import java.lang.reflect.Method;

public final class BlockJsonSerde {
    private static final String BLOCK_SERDE_UTIL_CLASS_NAME = "io.trino.block.BlockSerdeUtil";

    public static class Deserializer
    extends JsonDeserializer<Block> {
        private final BlockEncodingSerde blockEncodingSerde;
        private final Method readBlock;

        public Deserializer(BlockEncodingSerde blockEncodingSerde) throws Exception {
            this.blockEncodingSerde = blockEncodingSerde;
            Class<?> clazz = blockEncodingSerde.getClass().getClassLoader().loadClass(BlockJsonSerde.BLOCK_SERDE_UTIL_CLASS_NAME);
            this.readBlock = clazz.getDeclaredMethod("readBlock", BlockEncodingSerde.class, Slice.class);
        }

        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            byte[] decoded = jsonParser.getBinaryValue(Base64Variants.MIME_NO_LINEFEEDS);
            try {
                return (Block)this.readBlock.invoke(null, this.blockEncodingSerde, Slices.wrappedBuffer((byte[])decoded));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<Block> {
        private final BlockEncodingSerde blockEncodingSerde;
        private final Method writeBlock;

        public Serializer(BlockEncodingSerde blockEncodingSerde) throws Exception {
            this.blockEncodingSerde = blockEncodingSerde;
            Class<?> clazz = blockEncodingSerde.getClass().getClassLoader().loadClass(BlockJsonSerde.BLOCK_SERDE_UTIL_CLASS_NAME);
            this.writeBlock = clazz.getDeclaredMethod("writeBlock", BlockEncodingSerde.class, SliceOutput.class, Block.class);
        }

        public void serialize(Block block, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(block.getSizeInBytes() + (long)block.getEncodingName().length() + 8L));
            try {
                this.writeBlock.invoke(null, this.blockEncodingSerde, output, block);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Slice slice = output.slice();
            jsonGenerator.writeBinary(Base64Variants.MIME_NO_LINEFEEDS, slice.byteArray(), slice.byteArrayOffset(), slice.length());
        }
    }
}

