/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergViewOperationDispatcher;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateViewEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateViewFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateViewPreEvent;
import org.apache.gravitino.listener.api.event.IcebergDropViewEvent;
import org.apache.gravitino.listener.api.event.IcebergDropViewFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergDropViewPreEvent;
import org.apache.gravitino.listener.api.event.IcebergListViewEvent;
import org.apache.gravitino.listener.api.event.IcebergListViewFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergListViewPreEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadViewEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadViewFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadViewPreEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameViewEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameViewFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameViewPreEvent;
import org.apache.gravitino.listener.api.event.IcebergReplaceViewEvent;
import org.apache.gravitino.listener.api.event.IcebergReplaceViewFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergReplaceViewPreEvent;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.listener.api.event.IcebergViewExistsEvent;
import org.apache.gravitino.listener.api.event.IcebergViewExistsFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergViewExistsPreEvent;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;

public class IcebergViewEventDispatcher
implements IcebergViewOperationDispatcher {
    private IcebergViewOperationDispatcher icebergViewOperationDispatcher;
    private EventBus eventBus;
    private String metalakeName;

    public IcebergViewEventDispatcher(IcebergViewOperationDispatcher icebergViewOperationDispatcher, EventBus eventBus, String metalakeName) {
        this.icebergViewOperationDispatcher = icebergViewOperationDispatcher;
        this.eventBus = eventBus;
        this.metalakeName = metalakeName;
    }

    @Override
    public LoadViewResponse createView(IcebergRequestContext context, Namespace namespace, CreateViewRequest createViewRequest) {
        LoadViewResponse loadViewResponse;
        TableIdentifier viewIdentifier = TableIdentifier.of((Namespace)namespace, (String)createViewRequest.name());
        NameIdentifier nameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), viewIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateViewPreEvent(context, nameIdentifier, createViewRequest));
        try {
            loadViewResponse = this.icebergViewOperationDispatcher.createView(context, namespace, createViewRequest);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateViewFailureEvent(context, nameIdentifier, createViewRequest, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateViewEvent(context, nameIdentifier, createViewRequest, loadViewResponse));
        return loadViewResponse;
    }

    @Override
    public LoadViewResponse replaceView(IcebergRequestContext context, TableIdentifier viewIdentifier, UpdateTableRequest replaceViewRequest) {
        LoadViewResponse loadViewResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), viewIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergReplaceViewPreEvent(context, gravitinoNameIdentifier, replaceViewRequest));
        try {
            loadViewResponse = this.icebergViewOperationDispatcher.replaceView(context, viewIdentifier, replaceViewRequest);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergReplaceViewFailureEvent(context, gravitinoNameIdentifier, replaceViewRequest, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergReplaceViewEvent(context, gravitinoNameIdentifier, replaceViewRequest, loadViewResponse));
        return loadViewResponse;
    }

    @Override
    public void dropView(IcebergRequestContext context, TableIdentifier viewIdentifier) {
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), viewIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergDropViewPreEvent(context, gravitinoNameIdentifier));
        try {
            this.icebergViewOperationDispatcher.dropView(context, viewIdentifier);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergDropViewFailureEvent(context, gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergDropViewEvent(context, gravitinoNameIdentifier));
    }

    @Override
    public LoadViewResponse loadView(IcebergRequestContext context, TableIdentifier viewIdentifier) {
        LoadViewResponse loadViewResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), viewIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadViewPreEvent(context, gravitinoNameIdentifier));
        try {
            loadViewResponse = this.icebergViewOperationDispatcher.loadView(context, viewIdentifier);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadViewFailureEvent(context, gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadViewEvent(context, gravitinoNameIdentifier, loadViewResponse));
        return loadViewResponse;
    }

    @Override
    public ListTablesResponse listView(IcebergRequestContext context, Namespace namespace) {
        ListTablesResponse listViewsResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), namespace);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergListViewPreEvent(context, gravitinoNameIdentifier));
        try {
            listViewsResponse = this.icebergViewOperationDispatcher.listView(context, namespace);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergListViewFailureEvent(context, gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergListViewEvent(context, gravitinoNameIdentifier));
        return listViewsResponse;
    }

    @Override
    public boolean viewExists(IcebergRequestContext context, TableIdentifier viewIdentifier) {
        boolean isExists;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), viewIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergViewExistsPreEvent(context, gravitinoNameIdentifier));
        try {
            isExists = this.icebergViewOperationDispatcher.viewExists(context, viewIdentifier);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergViewExistsFailureEvent(context, gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergViewExistsEvent(context, gravitinoNameIdentifier, isExists));
        return isExists;
    }

    @Override
    public void renameView(IcebergRequestContext context, RenameTableRequest renameViewRequest) {
        TableIdentifier sourceView = renameViewRequest.source();
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), sourceView);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameViewPreEvent(context, gravitinoNameIdentifier, renameViewRequest));
        try {
            this.icebergViewOperationDispatcher.renameView(context, renameViewRequest);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameViewFailureEvent(context, gravitinoNameIdentifier, renameViewRequest, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameViewEvent(context, gravitinoNameIdentifier, renameViewRequest));
    }
}

