/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import com.google.common.base.Preconditions;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.UserPrincipal;
import org.apache.gravitino.auth.SignatureAlgorithmFamilyType;
import org.apache.gravitino.exceptions.UnauthorizedException;
import org.apache.gravitino.server.authentication.Authenticator;
import org.apache.gravitino.server.authentication.OAuthConfig;

class OAuth2TokenAuthenticator
implements Authenticator {
    private long allowSkewSeconds;
    private Key defaultSigningKey;
    private String serviceAudience;

    OAuth2TokenAuthenticator() {
    }

    @Override
    public boolean isDataFromToken() {
        return true;
    }

    @Override
    public Principal authenticateToken(byte[] tokenData) {
        if (tokenData == null) {
            throw new UnauthorizedException("Empty token authorization header", new Object[0]);
        }
        String authData = new String(tokenData, StandardCharsets.UTF_8);
        if (StringUtils.isBlank((CharSequence)authData) || !authData.startsWith("Bearer ")) {
            throw new UnauthorizedException("Invalid token authorization header", new Object[0]);
        }
        String token = authData.substring("Bearer ".length());
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new UnauthorizedException("Blank token found", new Object[0]);
        }
        try {
            JwtParser parser = Jwts.parserBuilder().setAllowedClockSkewSeconds(this.allowSkewSeconds).setSigningKey(this.defaultSigningKey).build();
            Jws jwt = parser.parseClaimsJws(token);
            Object audienceObject = ((Claims)jwt.getBody()).get((Object)"aud");
            if (audienceObject == null) {
                throw new UnauthorizedException("Found null Audience in token", new Object[0]);
            }
            if (audienceObject instanceof String) {
                if (!this.serviceAudience.equals(audienceObject)) {
                    throw new UnauthorizedException("Audience in the token [%s] doesn't contain %s", new Object[]{audienceObject, this.serviceAudience});
                }
            } else if (audienceObject instanceof List) {
                List audiences = (List)audienceObject;
                if (audiences.stream().noneMatch(audienceInToken -> audienceInToken.equals(this.serviceAudience))) {
                    throw new UnauthorizedException("Audiences in the token %s don't contain %s", new Object[]{audienceObject, this.serviceAudience});
                }
            } else {
                throw new UnauthorizedException("Audiences in token is not in expected format: %s", new Object[]{audienceObject});
            }
            return new UserPrincipal(((Claims)jwt.getBody()).getSubject());
        }
        catch (ExpiredJwtException | MalformedJwtException | UnsupportedJwtException | SignatureException | IllegalArgumentException e) {
            throw new UnauthorizedException(e, "JWT parse error", new Object[0]);
        }
    }

    @Override
    public void initialize(Config config) throws RuntimeException {
        this.serviceAudience = (String)config.get(OAuthConfig.SERVICE_AUDIENCE);
        this.allowSkewSeconds = (Long)config.get(OAuthConfig.ALLOW_SKEW_SECONDS);
        String configuredSignKey = (String)config.get(OAuthConfig.DEFAULT_SIGN_KEY);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)config.get(OAuthConfig.DEFAULT_TOKEN_PATH))), (Object)"The path for token of the default OAuth server can't be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)config.get(OAuthConfig.DEFAULT_SERVER_URI))), (Object)"The uri of the default OAuth server can't be blank");
        String algType = (String)config.get(OAuthConfig.SIGNATURE_ALGORITHM_TYPE);
        this.defaultSigningKey = OAuth2TokenAuthenticator.decodeSignKey(Base64.getDecoder().decode(configuredSignKey), algType);
    }

    @Override
    public boolean supportsToken(byte[] tokenData) {
        return tokenData != null && new String(tokenData, StandardCharsets.UTF_8).startsWith("Bearer ");
    }

    private static Key decodeSignKey(byte[] key, String algType) {
        try {
            SignatureAlgorithmFamilyType algFamilyType = SignatureAlgorithmFamilyType.valueOf((String)SignatureAlgorithm.valueOf((String)algType).getFamilyName());
            if (SignatureAlgorithmFamilyType.HMAC == algFamilyType) {
                return Keys.hmacShaKeyFor((byte[])key);
            }
            if (SignatureAlgorithmFamilyType.RSA == algFamilyType || SignatureAlgorithmFamilyType.ECDSA == algFamilyType) {
                X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
                KeyFactory kf = KeyFactory.getInstance(algFamilyType.name());
                return kf.generatePublic(spec);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decode key", e);
        }
        throw new IllegalArgumentException("Unsupported signature algorithm type: " + algType);
    }
}

