/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeVolumeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolUtils;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientDatanodeProtocolTranslatorPB
implements ProtocolMetaInterface,
ClientDatanodeProtocol,
ProtocolTranslator,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(ClientDatanodeProtocolTranslatorPB.class);
    private static final RpcController NULL_CONTROLLER = null;
    private final ClientDatanodeProtocolPB rpcProxy;
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto VOID_REFRESH_NAMENODES = ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto VOID_GET_DATANODE_INFO = ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetVolumeReportRequestProto VOID_GET_DATANODE_STORAGE_INFO = ClientDatanodeProtocolProtos.GetVolumeReportRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto VOID_GET_RECONFIG_STATUS = ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.StartReconfigurationRequestProto VOID_START_RECONFIG = ReconfigurationProtocolProtos.StartReconfigurationRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto VOID_LIST_RECONFIGURABLE_PROPERTIES = ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetBalancerBandwidthRequestProto VOID_GET_BALANCER_BANDWIDTH = ClientDatanodeProtocolProtos.GetBalancerBandwidthRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.EvictWritersRequestProto VOID_EVICT_WRITERS = ClientDatanodeProtocolProtos.EvictWritersRequestProto.newBuilder().build();

    public ClientDatanodeProtocolTranslatorPB(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(datanodeid, conf, socketTimeout, connectToDnViaHostname, locatedBlock);
    }

    public ClientDatanodeProtocolTranslatorPB(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, ticket, conf, factory, 0);
    }

    public ClientDatanodeProtocolTranslatorPB(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        LOG.debug("Connecting to datanode {} addr={}", (Object)dnAddr, (Object)addr);
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, UserGroupInformation.getCurrentUser(), conf, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
    }

    static ClientDatanodeProtocolPB createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        LOG.debug("Connecting to datanode {} addr={}", (Object)dnAddr, (Object)addr);
        Configuration confWithNoIpcIdle = new Configuration(conf);
        confWithNoIpcIdle.setInt("ipc.client.connection.maxidletime", 0);
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser((String)locatedBlock.getBlock().getLocalBlock().toString());
        ticket.addToken(locatedBlock.getBlockToken());
        return ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, ticket, confWithNoIpcIdle, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
    }

    static ClientDatanodeProtocolPB createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int socketTimeout) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientDatanodeProtocolPB.class, ProtobufRpcEngine.class);
        return (ClientDatanodeProtocolPB)RPC.getProxy(ClientDatanodeProtocolPB.class, (long)RPC.getProtocolVersion(ClientDatanodeProtocolPB.class), (InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)conf, (SocketFactory)factory, (int)socketTimeout);
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public long getReplicaVisibleLength(ExtendedBlock b) throws IOException {
        ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto req = ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto.newBuilder().setBlock(PBHelperClient.convert(b)).build();
        try {
            return this.rpcProxy.getReplicaVisibleLength(NULL_CONTROLLER, req).getLength();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void refreshNamenodes() throws IOException {
        try {
            this.rpcProxy.refreshNamenodes(NULL_CONTROLLER, VOID_REFRESH_NAMENODES);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void deleteBlockPool(String bpid, boolean force) throws IOException {
        ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto req = ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto.newBuilder().setBlockPool(bpid).setForce(force).build();
        try {
            this.rpcProxy.deleteBlockPool(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block, Token<BlockTokenIdentifier> token) throws IOException {
        ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto resp;
        ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto req = ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto.newBuilder().setBlock(PBHelperClient.convert(block)).setToken(PBHelperClient.convert(token)).build();
        try {
            resp = this.rpcProxy.getBlockLocalPathInfo(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        return new BlockLocalPathInfo(PBHelperClient.convert(resp.getBlock()), resp.getLocalPath(), resp.getLocalMetaPath());
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, ClientDatanodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ClientDatanodeProtocolPB.class), (String)methodName);
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public HdfsBlocksMetadata getHdfsBlocksMetadata(String blockPoolId, long[] blockIds, List<Token<BlockTokenIdentifier>> tokens) throws IOException {
        ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto response;
        ArrayList<SecurityProtos.TokenProto> tokensProtos = new ArrayList<SecurityProtos.TokenProto>(tokens.size());
        for (Token<BlockTokenIdentifier> t : tokens) {
            tokensProtos.add(PBHelperClient.convert(t));
        }
        ClientDatanodeProtocolProtos.GetHdfsBlockLocationsRequestProto request = ClientDatanodeProtocolProtos.GetHdfsBlockLocationsRequestProto.newBuilder().setBlockPoolId(blockPoolId).addAllBlockIds(Longs.asList((long[])blockIds)).addAllTokens(tokensProtos).build();
        try {
            response = this.rpcProxy.getHdfsBlockLocations(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        List<ByteString> volumeIdsByteStrings = response.getVolumeIdsList();
        ArrayList<byte[]> volumeIds = new ArrayList<byte[]>(volumeIdsByteStrings.size());
        for (ByteString bs : volumeIdsByteStrings) {
            volumeIds.add(bs.toByteArray());
        }
        List<Integer> volumeIndexes = response.getVolumeIndexesList();
        return new HdfsBlocksMetadata(blockPoolId, blockIds, volumeIds, volumeIndexes);
    }

    @Override
    public void shutdownDatanode(boolean forUpgrade) throws IOException {
        ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto request = ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto.newBuilder().setForUpgrade(forUpgrade).build();
        try {
            this.rpcProxy.shutdownDatanode(NULL_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void evictWriters() throws IOException {
        try {
            this.rpcProxy.evictWriters(NULL_CONTROLLER, VOID_EVICT_WRITERS);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public DatanodeLocalInfo getDatanodeInfo() throws IOException {
        try {
            ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto response = this.rpcProxy.getDatanodeInfo(NULL_CONTROLLER, VOID_GET_DATANODE_INFO);
            return PBHelperClient.convert(response.getLocalInfo());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void startReconfiguration() throws IOException {
        try {
            this.rpcProxy.startReconfiguration(NULL_CONTROLLER, VOID_START_RECONFIG);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException {
        try {
            return ReconfigurationProtocolUtils.getReconfigurationStatus(this.rpcProxy.getReconfigurationStatus(NULL_CONTROLLER, VOID_GET_RECONFIG_STATUS));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public List<String> listReconfigurableProperties() throws IOException {
        try {
            ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto response = this.rpcProxy.listReconfigurableProperties(NULL_CONTROLLER, VOID_LIST_RECONFIGURABLE_PROPERTIES);
            return response.getNameList();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void triggerBlockReport(BlockReportOptions options) throws IOException {
        try {
            this.rpcProxy.triggerBlockReport(NULL_CONTROLLER, ClientDatanodeProtocolProtos.TriggerBlockReportRequestProto.newBuilder().setIncremental(options.isIncremental()).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public long getBalancerBandwidth() throws IOException {
        try {
            ClientDatanodeProtocolProtos.GetBalancerBandwidthResponseProto response = this.rpcProxy.getBalancerBandwidth(NULL_CONTROLLER, VOID_GET_BALANCER_BANDWIDTH);
            return response.getBandwidth();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public List<DatanodeVolumeInfo> getVolumeReport() throws IOException {
        try {
            ArrayList<DatanodeVolumeInfo> volumeInfoList = new ArrayList<DatanodeVolumeInfo>();
            ClientDatanodeProtocolProtos.GetVolumeReportResponseProto volumeReport = this.rpcProxy.getVolumeReport(NULL_CONTROLLER, VOID_GET_DATANODE_STORAGE_INFO);
            List<HdfsProtos.DatanodeVolumeInfoProto> volumeProtoList = volumeReport.getVolumeInfoList();
            for (HdfsProtos.DatanodeVolumeInfoProto proto : volumeProtoList) {
                volumeInfoList.add(new DatanodeVolumeInfo(proto.getPath(), proto.getUsedSpace(), proto.getFreeSpace(), proto.getReservedSpace(), proto.getReservedSpaceForReplicas(), proto.getNumBlocks(), PBHelperClient.convertStorageType(proto.getStorageType())));
            }
            return volumeInfoList;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }
}

