/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.gravitino.storage.kv.TransactionalKvBackend;
import org.apache.gravitino.utils.Executable;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static <R> R executeWithReadLock(IOExecutable<R> executable, ReentrantReadWriteLock lock) throws IOException {
        if (lock.isWriteLockedByCurrentThread()) {
            return executable.execute();
        }
        lock.readLock().lock();
        try {
            R r = executable.execute();
            return r;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static <R> R executeWithWriteLock(IOExecutable<R> executable, ReentrantReadWriteLock lock) throws IOException {
        lock.writeLock().lock();
        try {
            R r = executable.execute();
            return r;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, E extends Exception> R executeInTransaction(Executable<R, E> executable, TransactionalKvBackend transactionalKvBackend) throws E, IOException {
        if (transactionalKvBackend.inTransaction()) {
            return executable.execute();
        }
        transactionalKvBackend.begin();
        try {
            R r = executable.execute();
            transactionalKvBackend.commit();
            R r2 = r;
            return r2;
        }
        finally {
            transactionalKvBackend.closeTransaction();
        }
    }

    @FunctionalInterface
    public static interface IOExecutable<R> {
        public R execute() throws IOException;
    }
}

