/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.file;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetChange;

@Evolving
public interface FilesetCatalog {
    public NameIdentifier[] listFilesets(Namespace var1) throws NoSuchSchemaException;

    public Fileset loadFileset(NameIdentifier var1) throws NoSuchFilesetException;

    default public boolean filesetExists(NameIdentifier ident) {
        try {
            this.loadFileset(ident);
            return true;
        }
        catch (NoSuchFilesetException e) {
            return false;
        }
    }

    public Fileset createFileset(NameIdentifier var1, String var2, Fileset.Type var3, String var4, Map<String, String> var5) throws NoSuchSchemaException, FilesetAlreadyExistsException;

    public Fileset alterFileset(NameIdentifier var1, FilesetChange ... var2) throws NoSuchFilesetException, IllegalArgumentException;

    public boolean dropFileset(NameIdentifier var1);
}

