/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.authorization.SecurableObjectDTO;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class RoleDTO
implements Role {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="audit")
    private AuditDTO audit;
    @Nullable
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="securableObjects")
    private SecurableObjectDTO[] securableObjects;

    protected RoleDTO() {
    }

    protected RoleDTO(String name, Map<String, String> properties, SecurableObjectDTO[] securableObjects, AuditDTO audit) {
        this.name = name;
        this.audit = audit;
        this.properties = properties;
        this.securableObjects = securableObjects;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public List<SecurableObject> securableObjects() {
        return Arrays.asList(this.securableObjects);
    }

    @Override
    public Audit auditInfo() {
        return this.audit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<S extends Builder> {
        protected String name;
        protected AuditDTO audit;
        protected Map<String, String> properties;
        protected SecurableObjectDTO[] securableObjects;

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withProperties(Map<String, String> properties) {
            if (properties != null) {
                this.properties = properties;
            }
            return (S)this;
        }

        public S withSecurableObjects(SecurableObjectDTO[] securableObjects) {
            this.securableObjects = securableObjects;
            return (S)this;
        }

        public S withAudit(AuditDTO audit) {
            this.audit = audit;
            return (S)this;
        }

        public RoleDTO build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "name cannot be null or empty");
            Preconditions.checkArgument(this.audit != null, "audit cannot be null");
            Preconditions.checkArgument(this.securableObjects != null && this.securableObjects.length != 0, "securable objects can't null or empty");
            return new RoleDTO(this.name, this.properties, this.securableObjects, this.audit);
        }
    }
}

