/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class MetadataObjectUtil {
    private static final Joiner DOT = Joiner.on((String)".");
    private static final BiMap<MetadataObject.Type, Entity.EntityType> TYPE_TO_TYPE_MAP = ImmutableBiMap.builder().put((Object)MetadataObject.Type.METALAKE, (Object)Entity.EntityType.METALAKE).put((Object)MetadataObject.Type.CATALOG, (Object)Entity.EntityType.CATALOG).put((Object)MetadataObject.Type.SCHEMA, (Object)Entity.EntityType.SCHEMA).put((Object)MetadataObject.Type.TABLE, (Object)Entity.EntityType.TABLE).put((Object)MetadataObject.Type.TOPIC, (Object)Entity.EntityType.TOPIC).put((Object)MetadataObject.Type.FILESET, (Object)Entity.EntityType.FILESET).put((Object)MetadataObject.Type.COLUMN, (Object)Entity.EntityType.COLUMN).put((Object)MetadataObject.Type.ROLE, (Object)Entity.EntityType.ROLE).build();

    private MetadataObjectUtil() {
    }

    public static Entity.EntityType toEntityType(MetadataObject metadataObject) {
        Preconditions.checkArgument((metadataObject != null ? 1 : 0) != 0, (Object)"metadataObject cannot be null");
        return Optional.ofNullable((Entity.EntityType)((Object)TYPE_TO_TYPE_MAP.get((Object)metadataObject.type()))).orElseThrow(() -> new IllegalArgumentException("Unknown metadata object type: " + metadataObject.type()));
    }

    public static NameIdentifier toEntityIdent(String metalakeName, MetadataObject metadataObject) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)metalakeName), (Object)"metalakeName cannot be blank");
        Preconditions.checkArgument((metadataObject != null ? 1 : 0) != 0, (Object)"metadataObject cannot be null");
        switch (metadataObject.type()) {
            case METALAKE: {
                return NameIdentifierUtil.ofMetalake(metalakeName);
            }
            case ROLE: {
                return AuthorizationUtils.ofRole(metalakeName, metadataObject.name());
            }
            case CATALOG: 
            case SCHEMA: 
            case TABLE: 
            case TOPIC: 
            case FILESET: {
                String fullName = DOT.join((Object)metalakeName, (Object)metadataObject.fullName(), new Object[0]);
                return NameIdentifier.parse((String)fullName);
            }
            case COLUMN: {
                throw new IllegalArgumentException("Cannot convert column metadata object to entity identifier: " + metadataObject.fullName());
            }
        }
        throw new IllegalArgumentException("Unknown metadata object type: " + metadataObject.type());
    }
}

