/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface UserMetaMapper {
    public static final String USER_TABLE_NAME = "user_meta";
    public static final String USER_ROLE_RELATION_TABLE_NAME = "user_role_rel";

    @Select(value={"SELECT user_id as userId FROM user_meta WHERE metalake_id = #{metalakeId} AND user_name = #{userName} AND deleted_at = 0"})
    public Long selectUserIdByMetalakeIdAndName(@Param(value="metalakeId") Long var1, @Param(value="userName") String var2);

    @Select(value={"SELECT user_id as userId, user_name as userName, metalake_id as metalakeId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM user_meta WHERE metalake_id = #{metalakeId} AND user_name = #{userName} AND deleted_at = 0"})
    public UserPO selectUserMetaByMetalakeIdAndName(@Param(value="metalakeId") Long var1, @Param(value="userName") String var2);

    @Insert(value={"INSERT INTO user_meta(user_id, user_name, metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{userMeta.userId}, #{userMeta.userName}, #{userMeta.metalakeId}, #{userMeta.auditInfo}, #{userMeta.currentVersion}, #{userMeta.lastVersion}, #{userMeta.deletedAt} )"})
    public void insertUserMeta(@Param(value="userMeta") UserPO var1);

    @Insert(value={"INSERT INTO user_meta(user_id, user_name,metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{userMeta.userId}, #{userMeta.userName}, #{userMeta.metalakeId}, #{userMeta.auditInfo}, #{userMeta.currentVersion}, #{userMeta.lastVersion}, #{userMeta.deletedAt} ) ON DUPLICATE KEY UPDATE user_name = #{userMeta.userName}, metalake_id = #{userMeta.metalakeId}, audit_info = #{userMeta.auditInfo}, current_version = #{userMeta.currentVersion}, last_version = #{userMeta.lastVersion}, deleted_at = #{userMeta.deletedAt}"})
    public void insertUserMetaOnDuplicateKeyUpdate(@Param(value="userMeta") UserPO var1);

    @Update(value={"UPDATE user_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE user_id = #{userId} AND deleted_at = 0"})
    public void softDeleteUserMetaByUserId(@Param(value="userId") Long var1);

    @Update(value={"UPDATE user_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public void softDeleteUserMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Update(value={"UPDATE user_meta SET user_name = #{newUserMeta.userName}, metalake_id = #{newUserMeta.metalakeId}, audit_info = #{newUserMeta.auditInfo}, current_version = #{newUserMeta.currentVersion}, last_version = #{newUserMeta.lastVersion}, deleted_at = #{newUserMeta.deletedAt} WHERE user_id = #{oldUserMeta.userId} AND user_name = #{oldUserMeta.userName} AND metalake_id = #{oldUserMeta.metalakeId} AND audit_info = #{oldUserMeta.auditInfo} AND current_version = #{oldUserMeta.currentVersion} AND last_version = #{oldUserMeta.lastVersion} AND deleted_at = 0"})
    public Integer updateUserMeta(@Param(value="newUserMeta") UserPO var1, @Param(value="oldUserMeta") UserPO var2);

    @Select(value={"SELECT us.user_id as userId, us.user_name as userName, us.metalake_id as metalakeId, us.audit_info as auditInfo, us.current_version as currentVersion, us.last_version as lastVersion, us.deleted_at as deletedAt FROM user_meta us JOIN user_role_rel re ON us.user_id = re.user_id WHERE re.role_id = #{roleId} AND us.deleted_at = 0 AND re.deleted_at = 0"})
    public List<UserPO> listUsersByRoleId(@Param(value="roleId") Long var1);

    @Delete(value={"DELETE FROM user_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteUserMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

