/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.TagPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface TagMetaMapper {
    public static final String TAG_TABLE_NAME = "tag_meta";

    @Select(value={"SELECT tm.tag_id as tagId, tm.tag_name as tagName, tm.metalake_id as metalakeId, tm.tag_comment as comment, tm.properties as properties, tm.audit_info as auditInfo, tm.current_version as currentVersion, tm.last_version as lastVersion, tm.deleted_at as deletedAt FROM tag_meta tm JOIN metalake_meta mm ON tm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND tm.deleted_at = 0 AND mm.deleted_at = 0"})
    public List<TagPO> listTagPOsByMetalake(@Param(value="metalakeName") String var1);

    @Select(value={"<script>SELECT tm.tag_id as tagId, tm.tag_name as tagName, tm.metalake_id as metalakeId, tm.tag_comment as comment, tm.properties as properties, tm.audit_info as auditInfo, tm.current_version as currentVersion, tm.last_version as lastVersion, tm.deleted_at as deletedAt FROM tag_meta tm JOIN metalake_meta mm ON tm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND tm.tag_name IN  <foreach item='tagName' index='index' collection='tagNames' open='(' separator=',' close=')'> #{tagName} </foreach> AND tm.deleted_at = 0 AND mm.deleted_at = 0</script>"})
    public List<TagPO> listTagPOsByMetalakeAndTagNames(@Param(value="metalakeName") String var1, @Param(value="tagNames") List<String> var2);

    @Select(value={"SELECT tm.tag_id as tagId FROM tag_meta tm JOIN metalake_meta mm ON tm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND tm.tag_name = #{tagName} AND tm.deleted_at = 0 AND mm.deleted_at = 0"})
    public Long selectTagIdByMetalakeAndName(@Param(value="metalakeName") String var1, @Param(value="tagName") String var2);

    @Select(value={"SELECT tm.tag_id as tagId, tm.tag_name as tagName, tm.metalake_id as metalakeId, tm.tag_comment as comment, tm.properties as properties, tm.audit_info as auditInfo, tm.current_version as currentVersion, tm.last_version as lastVersion, tm.deleted_at as deletedAt FROM tag_meta tm JOIN metalake_meta mm ON tm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND tm.tag_name = #{tagName} AND tm.deleted_at = 0 AND mm.deleted_at = 0"})
    public TagPO selectTagMetaByMetalakeAndName(@Param(value="metalakeName") String var1, @Param(value="tagName") String var2);

    @Insert(value={"INSERT INTO tag_meta (tag_id, tag_name, metalake_id, tag_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{tagMeta.tagId}, #{tagMeta.tagName}, #{tagMeta.metalakeId}, #{tagMeta.comment}, #{tagMeta.properties}, #{tagMeta.auditInfo}, #{tagMeta.currentVersion}, #{tagMeta.lastVersion}, #{tagMeta.deletedAt} )"})
    public void insertTagMeta(@Param(value="tagMeta") TagPO var1);

    @Insert(value={"INSERT INTO tag_meta(tag_id, tag_name, metalake_id, tag_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{tagMeta.tagId}, #{tagMeta.tagName}, #{tagMeta.metalakeId}, #{tagMeta.comment}, #{tagMeta.properties}, #{tagMeta.auditInfo}, #{tagMeta.currentVersion}, #{tagMeta.lastVersion}, #{tagMeta.deletedAt} ) ON DUPLICATE KEY UPDATE tag_name = #{tagMeta.tagName}, metalake_id = #{tagMeta.metalakeId}, tag_comment = #{tagMeta.comment}, properties = #{tagMeta.properties}, audit_info = #{tagMeta.auditInfo}, current_version = #{tagMeta.currentVersion}, last_version = #{tagMeta.lastVersion}, deleted_at = #{tagMeta.deletedAt}"})
    public void insertTagMetaOnDuplicateKeyUpdate(@Param(value="tagMeta") TagPO var1);

    @Update(value={"UPDATE tag_meta SET tag_name = #{newTagMeta.tagName}, tag_comment = #{newTagMeta.comment}, properties = #{newTagMeta.properties}, audit_info = #{newTagMeta.auditInfo}, current_version = #{newTagMeta.currentVersion}, last_version = #{newTagMeta.lastVersion}, deleted_at = #{newTagMeta.deletedAt} WHERE tag_id = #{oldTagMeta.tagId} AND metalake_id = #{oldTagMeta.metalakeId} AND tag_name = #{oldTagMeta.tagName} AND (tag_comment IS NULL OR tag_comment = #{oldTagMeta.comment}) AND properties = #{oldTagMeta.properties} AND audit_info = #{oldTagMeta.auditInfo} AND current_version = #{oldTagMeta.currentVersion} AND last_version = #{oldTagMeta.lastVersion} AND deleted_at = 0"})
    public Integer updateTagMeta(@Param(value="newTagMeta") TagPO var1, @Param(value="oldTagMeta") TagPO var2);

    @Update(value={"UPDATE tag_meta tm SET tm.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE tm.metalake_id IN ( SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND tm.tag_name = #{tagName} AND tm.deleted_at = 0"})
    public Integer softDeleteTagMetaByMetalakeAndTagName(@Param(value="metalakeName") String var1, @Param(value="tagName") String var2);

    @Update(value={"UPDATE tag_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public void softDeleteTagMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Delete(value={"DELETE FROM tag_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteTagMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

