/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Privileges;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.proto.AuditInfoSerDe;
import org.apache.gravitino.proto.ProtoSerDe;
import org.apache.gravitino.proto.Role;
import org.apache.gravitino.proto.SecurableObject;

public class RoleEntitySerDe
implements ProtoSerDe<RoleEntity, Role> {
    @Override
    public Role serialize(RoleEntity roleEntity) {
        Role.Builder builder = Role.newBuilder().setId(roleEntity.id().longValue()).setName(roleEntity.name()).setAuditInfo(new AuditInfoSerDe().serialize(roleEntity.auditInfo()));
        for (org.apache.gravitino.authorization.SecurableObject securableObject : roleEntity.securableObjects()) {
            builder.addSecurableObjects(SecurableObject.newBuilder().setFullName(securableObject.fullName()).setType(securableObject.type().name()).addAllPrivilegeConditions((Iterable)securableObject.privileges().stream().map(Privilege::condition).map(Enum::name).collect(Collectors.toList())).addAllPrivilegeNames((Iterable)securableObject.privileges().stream().map(Privilege::name).map(Enum::name).collect(Collectors.toList())).build());
        }
        if (roleEntity.properties() != null && !roleEntity.properties().isEmpty()) {
            builder.putAllProperties(roleEntity.properties());
        }
        return builder.build();
    }

    @Override
    public RoleEntity deserialize(Role role, Namespace namespace) {
        ArrayList securableObjects = Lists.newArrayList();
        for (int index = 0; index < role.getSecurableObjectsCount(); ++index) {
            ArrayList privileges = Lists.newArrayList();
            SecurableObject object = role.getSecurableObjects(index);
            for (int privIndex = 0; privIndex < object.getPrivilegeConditionsCount(); ++privIndex) {
                if (Privilege.Condition.ALLOW.name().equals(object.getPrivilegeConditions(privIndex))) {
                    privileges.add(Privileges.allow((String)object.getPrivilegeNames(privIndex)));
                    continue;
                }
                privileges.add(Privileges.deny((String)object.getPrivilegeNames(privIndex)));
            }
            org.apache.gravitino.authorization.SecurableObject securableObject = SecurableObjects.parse((String)object.getFullName(), (MetadataObject.Type)MetadataObject.Type.valueOf((String)object.getType()), (List)privileges);
            securableObjects.add(securableObject);
        }
        RoleEntity.Builder builder = RoleEntity.builder().withId(role.getId()).withName(role.getName()).withNamespace(namespace).withSecurableObjects(securableObjects).withAuditInfo(new AuditInfoSerDe().deserialize(role.getAuditInfo(), namespace));
        if (!role.getPropertiesMap().isEmpty()) {
            builder.withProperties(role.getPropertiesMap());
        }
        return builder.build();
    }
}

