/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.org.apache.commons.configuration.interpol;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.fluss.shaded.org.apache.commons.configuration.interpol.ConstantLookup;
import org.apache.fluss.shaded.org.apache.commons.lang.text.StrLookup;

public class ConfigurationInterpolator
extends StrLookup {
    public static final String PREFIX_SYSPROPERTIES = "sys";
    public static final String PREFIX_CONSTANTS = "const";
    private static final char PREFIX_SEPARATOR = ':';
    private static Map globalLookups = new HashMap();
    private Map localLookups;
    private StrLookup defaultLookup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationInterpolator() {
        Map map = globalLookups;
        synchronized (map) {
            this.localLookups = new HashMap(globalLookups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalLookup(String prefix, StrLookup lookup2) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (lookup2 == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        Map map = globalLookups;
        synchronized (map) {
            globalLookups.put(prefix, lookup2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deregisterGlobalLookup(String prefix) {
        Map map = globalLookups;
        synchronized (map) {
            return globalLookups.remove(prefix) != null;
        }
    }

    public void registerLookup(String prefix, StrLookup lookup2) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (lookup2 == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        this.localLookups.put(prefix, lookup2);
    }

    public boolean deregisterLookup(String prefix) {
        return this.localLookups.remove(prefix) != null;
    }

    public Set prefixSet() {
        return this.localLookups.keySet();
    }

    public StrLookup getDefaultLookup() {
        return this.defaultLookup;
    }

    public void setDefaultLookup(StrLookup defaultLookup) {
        this.defaultLookup = defaultLookup;
    }

    public String lookup(String var) {
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = var.substring(0, prefixPos);
            String name = var.substring(prefixPos + 1);
            String value = this.fetchLookupForPrefix(prefix).lookup(name);
            if (value != null) {
                return value;
            }
        }
        return this.fetchNoPrefixLookup().lookup(var);
    }

    protected StrLookup fetchNoPrefixLookup() {
        return this.getDefaultLookup() != null ? this.getDefaultLookup() : StrLookup.noneLookup();
    }

    protected StrLookup fetchLookupForPrefix(String prefix) {
        StrLookup lookup2 = (StrLookup)this.localLookups.get(prefix);
        if (lookup2 == null) {
            lookup2 = StrLookup.noneLookup();
        }
        return lookup2;
    }

    static {
        globalLookups.put(PREFIX_SYSPROPERTIES, StrLookup.systemPropertiesLookup());
        globalLookups.put(PREFIX_CONSTANTS, new ConstantLookup());
    }
}

