/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.EncodingUtils;
import org.apache.paimon.utils.StringUtils;

@Public
public final class DataField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final String name;
    private final DataType type;
    @Nullable
    private final String description;
    @Nullable
    private final String defaultValue;

    public DataField(int id, String name, DataType dataType) {
        this(id, name, dataType, null, null);
    }

    public DataField(int id, String name, DataType dataType, @Nullable String description) {
        this(id, name, dataType, description, null);
    }

    public DataField(int id, String name, DataType type, @Nullable String description, @Nullable String defaultValue) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.description = description;
        this.defaultValue = defaultValue;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public DataType type() {
        return this.type;
    }

    public DataField newId(int newId) {
        return new DataField(newId, this.name, this.type, this.description, this.defaultValue);
    }

    public DataField newName(String newName) {
        return new DataField(this.id, newName, this.type, this.description, this.defaultValue);
    }

    public DataField newType(DataType newType) {
        return new DataField(this.id, this.name, newType, this.description, this.defaultValue);
    }

    public DataField newDescription(String newDescription) {
        return new DataField(this.id, this.name, this.type, this.defaultValue, newDescription);
    }

    public DataField newDefaultValue(String newDefaultValue) {
        return new DataField(this.id, this.name, this.type, newDefaultValue, this.description);
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public String defaultValue() {
        return this.defaultValue;
    }

    public DataField copy() {
        return new DataField(this.id, this.name, this.type.copy(), this.description, this.defaultValue);
    }

    public DataField copy(boolean isNullable) {
        return new DataField(this.id, this.name, this.type.copy(isNullable), this.description, this.defaultValue);
    }

    public String asSQLString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EncodingUtils.escapeIdentifier(this.name)).append(" ").append(this.type.asSQLString());
        if (StringUtils.isNotEmpty(this.description)) {
            sb.append(" COMMENT '").append(EncodingUtils.escapeSingleQuotes(this.description)).append("'");
        }
        if (this.defaultValue != null) {
            sb.append(" DEFAULT ").append(this.defaultValue);
        }
        return sb.toString();
    }

    public void serializeJson(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField("id", this.id());
        generator.writeStringField("name", this.name());
        generator.writeFieldName("type");
        this.type.serializeJson(generator);
        if (this.description() != null) {
            generator.writeStringField("description", this.description());
        }
        if (this.defaultValue() != null) {
            generator.writeStringField("defaultValue", this.defaultValue());
        }
        generator.writeEndObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataField field = (DataField)o;
        return Objects.equals(this.id, field.id) && Objects.equals(this.name, field.name) && Objects.equals(this.type, field.type) && Objects.equals(this.description, field.description) && Objects.equals(this.defaultValue, field.defaultValue);
    }

    public boolean equalsIgnoreFieldId(DataField other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return Objects.equals(this.name, other.name) && this.type.equalsIgnoreFieldId(other.type) && Objects.equals(this.description, other.description) && Objects.equals(this.defaultValue, other.defaultValue);
    }

    public boolean isPrunedFrom(DataField other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && this.type.isPrunedFrom(other.type) && Objects.equals(this.description, other.description) && Objects.equals(this.defaultValue, other.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.description, this.defaultValue);
    }

    public String toString() {
        return this.asSQLString();
    }

    public static boolean dataFieldEqualsIgnoreId(DataField dataField1, DataField dataField2) {
        if (dataField1 == dataField2) {
            return true;
        }
        if (dataField1 != null && dataField2 != null) {
            return Objects.equals(dataField1.name(), dataField2.name()) && Objects.equals(dataField1.type(), dataField2.type()) && Objects.equals(dataField1.description(), dataField2.description()) && Objects.equals(dataField1.defaultValue(), dataField2.defaultValue());
        }
        return false;
    }
}

