/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.fesod.sheet.converters.file;

import java.io.File;
import java.io.IOException;
import org.apache.fesod.sheet.converters.Converter;
import org.apache.fesod.sheet.metadata.GlobalConfiguration;
import org.apache.fesod.sheet.metadata.data.WriteCellData;
import org.apache.fesod.sheet.metadata.property.ExcelContentProperty;
import org.apache.fesod.sheet.util.FileUtils;

/**
 * File and image converter
 *
 *
 */
public class FileImageConverter implements Converter<File> {
    @Override
    public Class<?> supportJavaTypeKey() {
        return File.class;
    }

    @Override
    public WriteCellData<?> convertToExcelData(
            File value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration)
            throws IOException {
        return new WriteCellData<>(FileUtils.readFileToByteArray(value));
    }
}
