/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server;

import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.base.util.AsyncRetry;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.base.util.exception.RetryTimeoutException;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.basescheduler.exception.BatcherUnavailableException;
import org.apache.bifromq.inbox.record.TenantInboxInstance;
import org.apache.bifromq.inbox.rpc.proto.SendReply;
import org.apache.bifromq.inbox.rpc.proto.SendRequest;
import org.apache.bifromq.inbox.server.InboxWriterPipeline;
import org.apache.bifromq.inbox.server.scheduler.IInboxInsertScheduler;
import org.apache.bifromq.inbox.storage.proto.InsertRequest;
import org.apache.bifromq.inbox.storage.proto.InsertResult;
import org.apache.bifromq.inbox.storage.proto.MatchedRoute;
import org.apache.bifromq.inbox.storage.proto.SubMessagePack;
import org.apache.bifromq.plugin.subbroker.DeliveryPack;
import org.apache.bifromq.plugin.subbroker.DeliveryPackage;
import org.apache.bifromq.plugin.subbroker.DeliveryReply;
import org.apache.bifromq.plugin.subbroker.DeliveryResult;
import org.apache.bifromq.plugin.subbroker.TypeUtil;
import org.apache.bifromq.sysprops.props.DataPlaneMaxBurstLatencyMillis;
import org.apache.bifromq.type.MatchInfo;
import org.apache.bifromq.type.TopicMessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxWriter
implements InboxWriterPipeline.ISendRequestHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxWriter.class);
    private final IInboxInsertScheduler insertScheduler;
    private final long retryTimeoutNanos;

    InboxWriter(IInboxInsertScheduler insertScheduler) {
        this.insertScheduler = insertScheduler;
        this.retryTimeoutNanos = Duration.ofMillis((Long)DataPlaneMaxBurstLatencyMillis.INSTANCE.get()).toNanos();
    }

    @Override
    public CompletableFuture<SendReply> handle(SendRequest request) {
        LinkedHashMap<TenantInboxInstance, Map> matchInfosByInbox = new LinkedHashMap<TenantInboxInstance, Map>();
        LinkedHashMap<TenantInboxInstance, List> subMsgPacksByInbox = new LinkedHashMap<TenantInboxInstance, List>();
        for (String tenantId : request.getRequest().getPackageMap().keySet()) {
            for (DeliveryPack pack : ((DeliveryPackage)request.getRequest().getPackageMap().get(tenantId)).getPackList()) {
                TopicMessagePack topicMessagePack = pack.getMessagePack();
                HashMap<TenantInboxInstance, SubMessagePack.Builder> subMsgPackByInbox = new HashMap<TenantInboxInstance, SubMessagePack.Builder>();
                for (MatchInfo matchInfo : pack.getMatchInfoList()) {
                    TenantInboxInstance tenantInboxInstance = TenantInboxInstance.from((String)tenantId, (MatchInfo)matchInfo);
                    MatchedRoute matchedRoute = MatchedRoute.newBuilder().setTopicFilter(matchInfo.getMatcher().getMqttTopicFilter()).setIncarnation(matchInfo.getIncarnation()).build();
                    matchInfosByInbox.computeIfAbsent(tenantInboxInstance, k -> new HashMap()).put(matchedRoute, matchInfo);
                    subMsgPackByInbox.computeIfAbsent(tenantInboxInstance, k -> SubMessagePack.newBuilder().setMessages(topicMessagePack)).addMatchedRoute(matchedRoute);
                }
                for (TenantInboxInstance tenantInboxInstance : subMsgPackByInbox.keySet()) {
                    subMsgPacksByInbox.computeIfAbsent(tenantInboxInstance, k -> new LinkedList()).add(((SubMessagePack.Builder)subMsgPackByInbox.get(tenantInboxInstance)).build());
                }
            }
        }
        List<CompletableFuture> replyFutures = subMsgPacksByInbox.entrySet().stream().map(entry -> {
            InsertRequest insertRequest = InsertRequest.newBuilder().setTenantId(((TenantInboxInstance)entry.getKey()).tenantId()).setInboxId(((TenantInboxInstance)entry.getKey()).instance().inboxId()).setIncarnation(((TenantInboxInstance)entry.getKey()).instance().incarnation()).addAllMessagePack((Iterable)entry.getValue()).build();
            return AsyncRetry.exec(() -> this.insertScheduler.schedule(insertRequest), (v, e) -> {
                boolean needRetry;
                if (e == null) {
                    return false;
                }
                boolean bl = needRetry = e instanceof BatcherUnavailableException || e instanceof TryLaterException || e instanceof BadVersionException;
                if (needRetry) {
                    log.debug("Retrying insert for inbox {} incarnation {} due to {}", new Object[]{insertRequest.getInboxId(), insertRequest.getIncarnation(), e.getClass().getSimpleName()});
                }
                return needRetry;
            }, (long)(this.retryTimeoutNanos / 5L), (long)this.retryTimeoutNanos);
        }).toList();
        return CompletableFuture.allOf(replyFutures.toArray(new CompletableFuture[0])).handle(CompletableFutureUtil.unwrap((v, e) -> {
            if (e != null) {
                if (e instanceof RetryTimeoutException) {
                    return SendReply.newBuilder().setReqId(request.getReqId()).setReply(DeliveryReply.newBuilder().setCode(DeliveryReply.Code.BACK_PRESSURE_REJECTED).build()).build();
                }
                if (e instanceof BackPressureException) {
                    return SendReply.newBuilder().setReqId(request.getReqId()).setReply(DeliveryReply.newBuilder().setCode(DeliveryReply.Code.BACK_PRESSURE_REJECTED).build()).build();
                }
                log.debug("Failed to insert", e);
                return SendReply.newBuilder().setReqId(request.getReqId()).setReply(DeliveryReply.newBuilder().setCode(DeliveryReply.Code.ERROR).build()).build();
            }
            assert (replyFutures.size() == subMsgPacksByInbox.size());
            SendReply.Builder replyBuilder = SendReply.newBuilder().setReqId(request.getReqId());
            HashMap<String, Map> tenantMatchResultMap = new HashMap<String, Map>();
            int i = 0;
            block4: for (TenantInboxInstance tenantInboxInstance : subMsgPacksByInbox.keySet()) {
                Map matchedRoutesMap = (Map)matchInfosByInbox.get(tenantInboxInstance);
                InsertResult result = (InsertResult)((CompletableFuture)replyFutures.get(i++)).join();
                Map matchResultMap = tenantMatchResultMap.computeIfAbsent(tenantInboxInstance.tenantId(), k -> new HashMap());
                switch (result.getCode()) {
                    case OK: {
                        Function<MatchedRoute, DeliveryResult.Code> resultFinder = this.getFinalResultFinder(result.getResultList());
                        for (MatchedRoute matchedRoute : matchedRoutesMap.keySet()) {
                            matchResultMap.putIfAbsent((MatchInfo)matchedRoutesMap.get(matchedRoute), resultFinder.apply(matchedRoute));
                        }
                        continue block4;
                    }
                    case NO_INBOX: {
                        for (MatchInfo matchInfo : matchedRoutesMap.values()) {
                            matchResultMap.putIfAbsent(matchInfo, DeliveryResult.Code.NO_RECEIVER);
                        }
                        continue block4;
                    }
                }
            }
            return replyBuilder.setReqId(request.getReqId()).setReply(DeliveryReply.newBuilder().setCode(DeliveryReply.Code.OK).putAllResult(TypeUtil.toResult(tenantMatchResultMap)).build()).build();
        }));
    }

    private Function<MatchedRoute, DeliveryResult.Code> getFinalResultFinder(List<InsertResult.SubStatus> subStatuses) {
        Function<MatchedRoute, DeliveryResult.Code> resultFinder = this.getResultFinder(subStatuses);
        return matchedRoute -> {
            DeliveryResult.Code code = (DeliveryResult.Code)resultFinder.apply((MatchedRoute)matchedRoute);
            if (code == null) {
                log.warn("MatchedRoute {} is missing in result", matchedRoute);
                return DeliveryResult.Code.NO_SUB;
            }
            return code;
        };
    }

    private Function<MatchedRoute, DeliveryResult.Code> getResultFinder(List<InsertResult.SubStatus> subStatuses) {
        if (subStatuses.size() == 1) {
            InsertResult.SubStatus onlyStatus = subStatuses.get(0);
            return matchedRoute -> {
                if (matchedRoute.equals((Object)onlyStatus.getMatchedRoute())) {
                    return onlyStatus.getRejected() ? DeliveryResult.Code.NO_SUB : DeliveryResult.Code.OK;
                }
                return null;
            };
        }
        if (subStatuses.size() < 10) {
            return matchedRoute -> {
                for (InsertResult.SubStatus status : subStatuses) {
                    if (!status.getMatchedRoute().equals(matchedRoute)) continue;
                    return status.getRejected() ? DeliveryResult.Code.NO_SUB : DeliveryResult.Code.OK;
                }
                return null;
            };
        }
        Map<MatchedRoute, DeliveryResult.Code> resultMap = subStatuses.stream().collect(Collectors.toMap(InsertResult.SubStatus::getMatchedRoute, e -> e.getRejected() ? DeliveryResult.Code.NO_SUB : DeliveryResult.Code.OK));
        return resultMap::get;
    }
}

