/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.Snapshot;

class RocksDBKVEngineIterator
implements AutoCloseable {
    private final RocksIterator rocksIterator;
    private final Runnable onClose;

    RocksDBKVEngineIterator(RocksDB db, ColumnFamilyHandle cfHandle, Snapshot snapshot, byte[] startKey, byte[] endKey) {
        this(db, cfHandle, snapshot, startKey, endKey, true);
    }

    RocksDBKVEngineIterator(RocksDB db, ColumnFamilyHandle cfHandle, Snapshot snapshot, byte[] startKey, byte[] endKey, boolean fillCache) {
        ReadOptions readOptions = new ReadOptions().setPinData(true).setFillCache(fillCache);
        Slice lowerSlice = null;
        if (startKey != null) {
            lowerSlice = new Slice(startKey);
            readOptions.setIterateLowerBound((AbstractSlice)lowerSlice);
        }
        Slice upperSlice = null;
        if (endKey != null) {
            upperSlice = new Slice(endKey);
            readOptions.setIterateUpperBound((AbstractSlice)upperSlice);
        }
        if (snapshot != null) {
            readOptions.setSnapshot(snapshot);
        }
        this.rocksIterator = db.newIterator(cfHandle, readOptions);
        this.onClose = new NativeState(this.rocksIterator, readOptions, lowerSlice, upperSlice);
    }

    public byte[] key() {
        return this.rocksIterator.key();
    }

    public byte[] value() {
        return this.rocksIterator.value();
    }

    public boolean isValid() {
        return this.rocksIterator.isValid();
    }

    public void next() {
        this.rocksIterator.next();
    }

    public void prev() {
        this.rocksIterator.prev();
    }

    public void seekToFirst() {
        this.rocksIterator.seekToFirst();
    }

    public void seekToLast() {
        this.rocksIterator.seekToLast();
    }

    public void seek(byte[] target) {
        this.rocksIterator.seek(target);
    }

    public void seekForPrev(byte[] target) {
        this.rocksIterator.seekForPrev(target);
    }

    public void refresh(Snapshot snapshot) {
        try {
            this.rocksIterator.refresh(snapshot);
        }
        catch (Throwable e) {
            throw new KVEngineException("Unable to refresh iterator", e);
        }
    }

    @Override
    public void close() {
        this.onClose.run();
    }

    private record NativeState(RocksIterator itr, ReadOptions readOptions, Slice lowerSlice, Slice upperSlice) implements Runnable
    {
        @Override
        public void run() {
            this.itr.close();
            this.readOptions.close();
            if (this.lowerSlice != null) {
                this.lowerSlice.close();
            }
            if (this.upperSlice != null) {
                this.upperSlice.close();
            }
        }
    }
}

