/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.client;

import java.lang.ref.Cleaner;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.inbox.rpc.proto.InboxFetchHint;
import org.apache.bifromq.inbox.rpc.proto.InboxFetched;
import org.apache.bifromq.inbox.rpc.proto.InboxServiceGrpc;
import org.apache.bifromq.inbox.storage.proto.Fetched;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxFetchPipeline {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxFetchPipeline.class);
    private static final Cleaner CLEANER = Cleaner.create();
    private final IRPCClient.IMessageStream<InboxFetched, InboxFetchHint> messageStream;
    private final String tenantId;
    private final Map<InboxFetchSessionId, Consumer<Fetched>> fetcherMap = new ConcurrentHashMap<InboxFetchSessionId, Consumer<Fetched>>();
    private final Cleaner.Cleanable cleanable;

    InboxFetchPipeline(String tenantId, String delivererKey, IRPCClient rpcClient) {
        this.tenantId = tenantId;
        this.messageStream = rpcClient.createMessageStream(tenantId, null, delivererKey, Map.of("0", UUID.randomUUID().toString(), "1", delivererKey), InboxServiceGrpc.getFetchMethod());
        this.cleanable = CLEANER.register(this, new PipelineCloseAction(this.messageStream));
        this.messageStream.onMessage((Consumer)new MessageListener(this.fetcherMap));
        this.messageStream.onRetarget((Consumer)new RetargetListener(this.fetcherMap));
    }

    public void fetch(long sessionId, String inboxId, long incarnation, Consumer<Fetched> consumer) {
        this.fetcherMap.put(new InboxFetchSessionId(sessionId, inboxId, incarnation), consumer);
    }

    public void stopFetch(long sessionId, String inboxId, long incarnation) {
        this.fetcherMap.remove(new InboxFetchSessionId(sessionId, inboxId, incarnation));
    }

    public void hint(long sessionId, String inboxId, long incarnation, int bufferCapacity, long lastFetchQoS0Seq, long lastFetchSendBufferSeq) {
        log.trace("Send hint: inboxId={}, incarnation={}, capacity={}, client={}, lastFetchedQoSeq={}, lastFetchedSendBufferSeq={}", new Object[]{inboxId, incarnation, bufferCapacity, this.tenantId, lastFetchQoS0Seq, lastFetchSendBufferSeq});
        this.messageStream.ack((Object)InboxFetchHint.newBuilder().setSessionId(sessionId).setInboxId(inboxId).setIncarnation(incarnation).setCapacity(bufferCapacity).setLastFetchQoS0Seq(lastFetchQoS0Seq).setLastFetchSendBufferSeq(lastFetchSendBufferSeq).build());
    }

    public void close() {
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
    }

    private record PipelineCloseAction(IRPCClient.IMessageStream<InboxFetched, InboxFetchHint> messageStream) implements Runnable
    {
        @Override
        public void run() {
            this.messageStream.close();
        }
    }

    private record MessageListener(Map<InboxFetchSessionId, Consumer<Fetched>> fetcherMap) implements Consumer<InboxFetched>
    {
        @Override
        public void accept(InboxFetched inboxFetched) {
            Consumer<Fetched> fetcher = this.fetcherMap.get(new InboxFetchSessionId(inboxFetched.getSessionId(), inboxFetched.getInboxId(), inboxFetched.getIncarnation()));
            if (fetcher != null) {
                Fetched fetched = inboxFetched.getFetched();
                fetcher.accept(fetched);
            }
        }
    }

    private record RetargetListener(Map<InboxFetchSessionId, Consumer<Fetched>> fetcherMap) implements Consumer<Long>
    {
        @Override
        public void accept(Long ts) {
            log.debug("Message stream retargeting, signal transient error to all fetchers");
            this.fetcherMap.values().forEach(consumer -> consumer.accept(Fetched.newBuilder().setResult(Fetched.Result.TRY_LATER).build()));
        }
    }

    private record InboxFetchSessionId(long sessionId, String inboxId, long incarnation) {
    }
}

