/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckPayload;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.mqtt.handler.RoutedMessage;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageUtils;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5AuthReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5DisconnectReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5PubAckReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5PubCompReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5PubRecReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5PubRelReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5SubAckReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5UnsubAckReasonCode;
import org.apache.bifromq.mqtt.spi.UserProperty;
import org.apache.bifromq.type.TopicFilterOption;
import org.apache.bifromq.type.UserProperties;

public class MQTT5MessageBuilders {
    public static AuthBuilder auth(String authMethod) {
        return new AuthBuilder(authMethod);
    }

    public static ConnAckPropertiesBuilder connAckProperties() {
        return new ConnAckPropertiesBuilder();
    }

    public static DisconnectBuilder disconnect() {
        return new DisconnectBuilder();
    }

    public static SubAckBuilder subAck() {
        return new SubAckBuilder();
    }

    public static UnsubAckBuilder unsubAck() {
        return new UnsubAckBuilder();
    }

    public static PubBuilder pub() {
        return new PubBuilder();
    }

    public static PubAckBuilder pubAck(boolean includeProblemInfo) {
        return new PubAckBuilder(includeProblemInfo);
    }

    public static PubRecBuilder pubRec(boolean includeProblemInfo) {
        return new PubRecBuilder(includeProblemInfo);
    }

    public static PubRelBuilder pubRel(boolean includeProblemInfo) {
        return new PubRelBuilder(includeProblemInfo);
    }

    public static PubCompBuilder pubComp(boolean includeProblemInfo) {
        return new PubCompBuilder(includeProblemInfo);
    }

    public static final class AuthBuilder {
        private final String authMethod;
        private ByteString authData;
        private MQTT5AuthReasonCode reasonCode;
        private String reasonString;
        private UserProperties userProps;

        public AuthBuilder(String authMethod) {
            this.authMethod = authMethod;
        }

        public AuthBuilder authData(ByteString authData) {
            this.authData = authData;
            return this;
        }

        public AuthBuilder reasonCode(MQTT5AuthReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public AuthBuilder reasonString(String reasonString) {
            this.reasonString = reasonString;
            return this;
        }

        public AuthBuilder userProperties(UserProperties userProps) {
            this.userProps = userProps;
            return this;
        }

        public MqttMessage build() {
            MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
            propsBuilder.addAuthMethod(this.authMethod);
            if (this.authData != null) {
                propsBuilder.addAuthData(this.authData);
            }
            if (!Strings.isNullOrEmpty((String)this.reasonString)) {
                propsBuilder.addReasonString(this.reasonString);
            }
            if (this.userProps != null) {
                propsBuilder.addUserProperties(this.userProps);
            }
            MqttProperties mqttProperties = propsBuilder.build();
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.AUTH, false, MqttQoS.AT_MOST_ONCE, false, 0);
            if (mqttProperties.isEmpty() && this.reasonCode == MQTT5AuthReasonCode.Success) {
                return new MqttMessage(fixedHeader);
            }
            MqttReasonCodeAndPropertiesVariableHeader variableHeader = new MqttReasonCodeAndPropertiesVariableHeader(this.reasonCode.value(), mqttProperties);
            return new MqttMessage(fixedHeader, (Object)variableHeader);
        }
    }

    public static final class ConnAckPropertiesBuilder {
        private final MqttProperties.UserProperties userProperties = new MqttProperties.UserProperties();
        private String clientId;
        private Long sessionExpiryInterval;
        private Integer receiveMaximum;
        private Byte maximumQos;
        private Boolean retain;
        private Long maximumPacketSize;
        private Integer topicAliasMaximum;
        private String reasonString;
        private Boolean wildcardSubscriptionAvailable;
        private Boolean subscriptionIdentifiersAvailable;
        private Boolean sharedSubscriptionAvailable;
        private Integer serverKeepAlive;
        private String responseInformation;
        private String serverReference;
        private String authenticationMethod;
        private byte[] authenticationData;

        public MqttProperties build() {
            MqttProperties props = new MqttProperties();
            if (this.clientId != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.ASSIGNED_CLIENT_IDENTIFIER.value(), this.clientId));
            }
            if (this.sessionExpiryInterval != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value(), Integer.valueOf(this.sessionExpiryInterval.intValue())));
            }
            if (this.receiveMaximum != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.RECEIVE_MAXIMUM.value(), this.receiveMaximum));
            }
            if (this.maximumQos != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.MAXIMUM_QOS.value(), this.receiveMaximum));
            }
            if (this.maximumPacketSize != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.MAXIMUM_PACKET_SIZE.value(), Integer.valueOf(this.maximumPacketSize.intValue())));
            }
            if (this.topicAliasMaximum != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.TOPIC_ALIAS_MAXIMUM.value(), this.topicAliasMaximum));
            }
            if (this.reasonString != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.REASON_STRING.value(), this.reasonString));
            }
            if (!((List)this.userProperties.value()).isEmpty()) {
                props.add((MqttProperties.MqttProperty)this.userProperties);
            }
            if (this.retain != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.RETAIN_AVAILABLE.value(), Integer.valueOf(this.retain != false ? 1 : 0)));
            }
            if (this.wildcardSubscriptionAvailable != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.WILDCARD_SUBSCRIPTION_AVAILABLE.value(), Integer.valueOf(this.wildcardSubscriptionAvailable != false ? 1 : 0)));
            }
            if (this.subscriptionIdentifiersAvailable != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER_AVAILABLE.value(), Integer.valueOf(this.subscriptionIdentifiersAvailable != false ? 1 : 0)));
            }
            if (this.sharedSubscriptionAvailable != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SHARED_SUBSCRIPTION_AVAILABLE.value(), Integer.valueOf(this.sharedSubscriptionAvailable != false ? 1 : 0)));
            }
            if (this.serverKeepAlive != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SERVER_KEEP_ALIVE.value(), this.serverKeepAlive));
            }
            if (this.responseInformation != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.RESPONSE_INFORMATION.value(), this.responseInformation));
            }
            if (this.serverReference != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.SERVER_REFERENCE.value(), this.serverReference));
            }
            if (this.authenticationMethod != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_METHOD.value(), this.authenticationMethod));
            }
            if (this.authenticationData != null) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.BinaryProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_DATA.value(), this.authenticationData));
            }
            return props;
        }

        public ConnAckPropertiesBuilder sessionExpiryInterval(long seconds) {
            this.sessionExpiryInterval = seconds;
            return this;
        }

        public ConnAckPropertiesBuilder receiveMaximum(int value) {
            this.receiveMaximum = value;
            return this;
        }

        public ConnAckPropertiesBuilder maximumQos(byte value) {
            if (value != 0 && value != 1) {
                throw new IllegalArgumentException("maximum QoS property could be 0 or 1");
            }
            this.maximumQos = value;
            return this;
        }

        public ConnAckPropertiesBuilder retainAvailable(boolean retain) {
            this.retain = retain;
            return this;
        }

        public ConnAckPropertiesBuilder maximumPacketSize(long size) {
            this.maximumPacketSize = size;
            return this;
        }

        public ConnAckPropertiesBuilder assignedClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ConnAckPropertiesBuilder topicAliasMaximum(int value) {
            this.topicAliasMaximum = value;
            return this;
        }

        public ConnAckPropertiesBuilder reasonString(String reason) {
            this.reasonString = reason;
            return this;
        }

        public ConnAckPropertiesBuilder userProperty(String name, String value) {
            this.userProperties.add(name, value);
            return this;
        }

        public ConnAckPropertiesBuilder wildcardSubscriptionAvailable(boolean value) {
            this.wildcardSubscriptionAvailable = value;
            return this;
        }

        public ConnAckPropertiesBuilder subscriptionIdentifiersAvailable(boolean value) {
            this.subscriptionIdentifiersAvailable = value;
            return this;
        }

        public ConnAckPropertiesBuilder sharedSubscriptionAvailable(boolean value) {
            this.sharedSubscriptionAvailable = value;
            return this;
        }

        public ConnAckPropertiesBuilder serverKeepAlive(int seconds) {
            this.serverKeepAlive = seconds;
            return this;
        }

        public ConnAckPropertiesBuilder responseInformation(String value) {
            this.responseInformation = value;
            return this;
        }

        public ConnAckPropertiesBuilder serverReference(String host) {
            this.serverReference = host;
            return this;
        }

        public ConnAckPropertiesBuilder authenticationMethod(String methodName) {
            this.authenticationMethod = methodName;
            return this;
        }

        public ConnAckPropertiesBuilder authenticationData(byte[] rawData) {
            this.authenticationData = (byte[])rawData.clone();
            return this;
        }
    }

    public static final class DisconnectBuilder {
        private MQTT5DisconnectReasonCode reasonCode;
        private String reasonString;
        private UserProperties userProps;
        private String serverReference;

        DisconnectBuilder() {
        }

        public DisconnectBuilder reasonCode(MQTT5DisconnectReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public DisconnectBuilder reasonString(String reason) {
            this.reasonString = reason;
            return this;
        }

        public DisconnectBuilder userProps(UserProperties userProps) {
            this.userProps = userProps;
            return this;
        }

        public DisconnectBuilder serverReference(String serverReference) {
            this.serverReference = serverReference;
            return this;
        }

        public MqttMessage build() {
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.DISCONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
            MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
            if (!Strings.isNullOrEmpty((String)this.reasonString) || this.userProps != null || !Strings.isNullOrEmpty((String)this.serverReference)) {
                if (!Strings.isNullOrEmpty((String)this.reasonString)) {
                    propsBuilder.addReasonString(this.reasonString);
                }
                if (!Strings.isNullOrEmpty((String)this.serverReference)) {
                    propsBuilder.addServerReference(this.serverReference);
                }
                if (this.userProps != null) {
                    propsBuilder.addUserProperties(this.userProps);
                }
            }
            MqttProperties mqttProperties = propsBuilder.build();
            if (this.reasonCode == MQTT5DisconnectReasonCode.Normal && mqttProperties.isEmpty()) {
                return new MqttMessage(fixedHeader);
            }
            MqttReasonCodeAndPropertiesVariableHeader variableHeader = new MqttReasonCodeAndPropertiesVariableHeader(this.reasonCode.value(), mqttProperties);
            return new MqttMessage(fixedHeader, (Object)variableHeader);
        }
    }

    public static final class SubAckBuilder {
        private int packetId;
        private List<MQTT5SubAckReasonCode> reasonCodes;
        private String reasonString;
        private UserProperties userProps;

        SubAckBuilder() {
        }

        public SubAckBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public SubAckBuilder reasonCodes(MQTT5SubAckReasonCode ... reasonCodes) {
            this.reasonCodes = List.of(reasonCodes);
            return this;
        }

        public SubAckBuilder reasonString(String reason) {
            this.reasonString = reason;
            return this;
        }

        public SubAckBuilder userProps(UserProperties userProps) {
            this.userProps = userProps;
            return this;
        }

        public MqttSubAckMessage build() {
            MqttMessageIdVariableHeader variableHeader;
            MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
            if (!Strings.isNullOrEmpty((String)this.reasonString) || this.userProps != null) {
                MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
                if (!Strings.isNullOrEmpty((String)this.reasonString)) {
                    propsBuilder.addReasonString(this.reasonString);
                }
                if (this.userProps != null) {
                    propsBuilder.addUserProperties(this.userProps);
                }
                variableHeader = new MqttMessageIdAndPropertiesVariableHeader(this.packetId, propsBuilder.build());
            } else {
                variableHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            }
            MqttSubAckPayload mqttSubAckPayload = new MqttSubAckPayload((Iterable)Lists.transform(this.reasonCodes, MQTT5SubAckReasonCode::value));
            return new MqttSubAckMessage(mqttFixedHeader, variableHeader, mqttSubAckPayload);
        }
    }

    public static final class UnsubAckBuilder {
        private final List<MQTT5UnsubAckReasonCode> reasonCodes = new ArrayList<MQTT5UnsubAckReasonCode>();
        private int packetId;
        private String reasonString;
        private UserProperties userProps;

        UnsubAckBuilder() {
        }

        public UnsubAckBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public UnsubAckBuilder addReasonCode(MQTT5UnsubAckReasonCode reasonCode) {
            this.reasonCodes.add(reasonCode);
            return this;
        }

        public UnsubAckBuilder addReasonCodes(MQTT5UnsubAckReasonCode ... reasonCodes) {
            this.reasonCodes.addAll(List.of(reasonCodes));
            return this;
        }

        public UnsubAckBuilder reasonString(String reason) {
            this.reasonString = reason;
            return this;
        }

        public UnsubAckBuilder userProps(UserProperties userProps) {
            this.userProps = userProps;
            return this;
        }

        public MqttUnsubAckMessage build() {
            MqttMessageIdVariableHeader variableHeader;
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
            if (!Strings.isNullOrEmpty((String)this.reasonString) || this.userProps != null) {
                MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
                if (!Strings.isNullOrEmpty((String)this.reasonString)) {
                    propsBuilder.addReasonString(this.reasonString);
                }
                if (this.userProps != null) {
                    propsBuilder.addUserProperties(this.userProps);
                }
                variableHeader = new MqttMessageIdAndPropertiesVariableHeader(this.packetId, propsBuilder.build());
            } else {
                variableHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            }
            MqttUnsubAckPayload unsubAckPayload = new MqttUnsubAckPayload((Iterable)Lists.transform(this.reasonCodes, MQTT5UnsubAckReasonCode::value));
            return new MqttUnsubAckMessage(fixedHeader, variableHeader, unsubAckPayload);
        }
    }

    public static final class PubBuilder {
        private int packetId;
        private RoutedMessage message;
        private boolean dup;
        private boolean setupAlias;
        private int topicAlias;
        private Iterable<UserProperty> extraUserProps = Collections.emptyList();

        public PubBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public PubBuilder dup(boolean dup) {
            this.dup = dup;
            return this;
        }

        public PubBuilder setupAlias(boolean setupAlias) {
            this.setupAlias = setupAlias;
            return this;
        }

        public PubBuilder topicAlias(int alias) {
            this.topicAlias = alias;
            return this;
        }

        public PubBuilder message(RoutedMessage message) {
            this.message = message;
            return this;
        }

        public PubBuilder extraUserProps(Iterable<UserProperty> userProperties) {
            this.extraUserProps = userProperties;
            return this;
        }

        public MqttPublishMessage build() {
            String topicName;
            MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
            TopicFilterOption option = this.message.option();
            if (option.hasSubId()) {
                propsBuilder.addSubscriptionIdentifier(option.getSubId());
            }
            if (this.topicAlias > 0) {
                topicName = this.setupAlias ? this.message.topic() : "";
                propsBuilder.addTopicAlias(this.topicAlias);
            } else {
                topicName = this.message.topic();
            }
            if (this.message.message().getIsUTF8String()) {
                propsBuilder.addPayloadFormatIndicator(1);
            }
            if (this.message.message().hasContentType()) {
                propsBuilder.addContentType(this.message.message().getContentType());
            }
            if (this.message.message().hasCorrelationData()) {
                propsBuilder.addCorrelationData(this.message.message().getCorrelationData());
            }
            if (this.message.message().hasResponseTopic()) {
                propsBuilder.addResponseTopic(this.message.message().getResponseTopic());
            }
            if (this.message.message().getUserProperties().getUserPropertiesCount() > 0) {
                propsBuilder.addUserProperties(this.message.message().getUserProperties());
            }
            this.extraUserProps.forEach(userProp -> propsBuilder.addUserProperty(userProp.key(), userProp.value()));
            if (this.message.message().getExpiryInterval() < Integer.MAX_VALUE) {
                long nowMs = HLC.INST.getPhysical();
                long msgMs = HLC.INST.getPhysical(this.message.message().getTimestamp());
                long elapsedMs = nowMs - msgMs;
                long totalMs = (long)this.message.message().getExpiryInterval() * 1000L;
                long leftMs = totalMs - elapsedMs;
                if (leftMs > 0L) {
                    int leftSec = (int)Math.max(1L, (long)Math.ceil((double)leftMs / 1000.0));
                    propsBuilder.addMessageExpiryInterval(leftSec);
                } else {
                    propsBuilder.addMessageExpiryInterval(0);
                }
            }
            MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, this.dup, MqttQoS.valueOf((int)this.message.qos().getNumber()), this.message.isRetain(), 0);
            MqttPublishVariableHeader mqttVariableHeader = new MqttPublishVariableHeader(topicName, this.packetId, propsBuilder.build());
            return new MqttPublishMessage(mqttFixedHeader, mqttVariableHeader, Unpooled.wrappedBuffer((ByteBuffer)this.message.message().getPayload().asReadOnlyByteBuffer()));
        }
    }

    public static final class PubAckBuilder {
        private final boolean includeProblemInfo;
        private int packetId;
        private MQTT5PubAckReasonCode reasonCode;
        private String reasonString;
        private UserProperties userProps;

        PubAckBuilder(boolean includeProblemInfo) {
            this.includeProblemInfo = includeProblemInfo;
        }

        public PubAckBuilder reasonCode(MQTT5PubAckReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public PubAckBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public PubAckBuilder reasonString(String reason) {
            this.reasonString = reason;
            return this;
        }

        public PubAckBuilder userProps(UserProperties userProps) {
            this.userProps = userProps;
            return this;
        }

        public MqttMessage build() {
            MqttMessageIdVariableHeader varHeader;
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
            if ((!this.includeProblemInfo || Strings.isNullOrEmpty((String)this.reasonString) && this.userProps == null) && this.reasonCode == MQTT5PubAckReasonCode.Success) {
                varHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            } else {
                MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
                if (this.includeProblemInfo && !Strings.isNullOrEmpty((String)this.reasonString)) {
                    propsBuilder.addReasonString(this.reasonString);
                }
                if (this.includeProblemInfo && this.userProps != null) {
                    propsBuilder.addUserProperties(this.userProps);
                }
                varHeader = new MqttPubReplyMessageVariableHeader(this.packetId, this.reasonCode.value(), propsBuilder.build());
            }
            return new MqttMessage(fixedHeader, (Object)varHeader);
        }
    }

    public static final class PubRecBuilder {
        private final boolean includeProblemInfo;
        private int packetId;
        private MQTT5PubRecReasonCode reasonCode;
        private String reasonString;
        private UserProperties userProps;

        PubRecBuilder(boolean includeProblemInfo) {
            this.includeProblemInfo = includeProblemInfo;
        }

        public PubRecBuilder reasonCode(MQTT5PubRecReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public PubRecBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public PubRecBuilder reasonString(String reason) {
            this.reasonString = reason;
            return this;
        }

        public PubRecBuilder userProps(UserProperties userProps) {
            this.userProps = userProps;
            return this;
        }

        public MqttMessage build() {
            MqttMessageIdVariableHeader varHeader;
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_MOST_ONCE, false, 2);
            if ((!this.includeProblemInfo || Strings.isNullOrEmpty((String)this.reasonString) && this.userProps == null) && this.reasonCode == MQTT5PubRecReasonCode.Success) {
                varHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            } else {
                MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
                if (this.includeProblemInfo && !Strings.isNullOrEmpty((String)this.reasonString)) {
                    propsBuilder.addReasonString(this.reasonString);
                }
                if (this.includeProblemInfo && this.userProps != null) {
                    propsBuilder.addUserProperties(this.userProps);
                }
                varHeader = new MqttPubReplyMessageVariableHeader(this.packetId, this.reasonCode.value(), propsBuilder.build());
            }
            return new MqttMessage(fixedHeader, (Object)varHeader);
        }
    }

    public static final class PubRelBuilder {
        private final boolean includeProblemInfo;
        private int packetId;
        private MQTT5PubRelReasonCode reasonCode;
        private String reasonString;
        private UserProperties userProps;

        PubRelBuilder(boolean includeProblemInfo) {
            this.includeProblemInfo = includeProblemInfo;
        }

        public PubRelBuilder reasonCode(MQTT5PubRelReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public PubRelBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public PubRelBuilder reasonString(String reason) {
            this.reasonString = reason;
            return this;
        }

        public PubRelBuilder userProps(UserProperties userProps) {
            this.userProps = userProps;
            return this;
        }

        public MqttMessage build() {
            MqttMessageIdVariableHeader varHeader;
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_LEAST_ONCE, false, 2);
            if ((!this.includeProblemInfo || Strings.isNullOrEmpty((String)this.reasonString) && this.userProps == null) && this.reasonCode == MQTT5PubRelReasonCode.Success) {
                varHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            } else {
                MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
                if (this.includeProblemInfo && !Strings.isNullOrEmpty((String)this.reasonString)) {
                    propsBuilder.addReasonString(this.reasonString);
                }
                if (this.includeProblemInfo && this.userProps != null) {
                    propsBuilder.addUserProperties(this.userProps);
                }
                varHeader = new MqttPubReplyMessageVariableHeader(this.packetId, this.reasonCode.value(), propsBuilder.build());
            }
            return new MqttMessage(fixedHeader, (Object)varHeader);
        }
    }

    public static final class PubCompBuilder {
        private final boolean includeProblemInfo;
        private int packetId;
        private MQTT5PubCompReasonCode reasonCode;
        private String reasonString;
        private UserProperties userProps;

        PubCompBuilder(boolean includeProblemInfo) {
            this.includeProblemInfo = includeProblemInfo;
        }

        public PubCompBuilder reasonCode(MQTT5PubCompReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public PubCompBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public PubCompBuilder reasonString(String reason) {
            this.reasonString = reason;
            return this;
        }

        public PubCompBuilder userProps(UserProperties userProps) {
            this.userProps = userProps;
            return this;
        }

        public MqttMessage build() {
            MqttMessageIdVariableHeader varHeader;
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 2);
            if ((!this.includeProblemInfo || Strings.isNullOrEmpty((String)this.reasonString) && this.userProps == null) && this.reasonCode == MQTT5PubCompReasonCode.Success) {
                varHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            } else {
                MQTT5MessageUtils.MqttPropertiesBuilder propsBuilder = MQTT5MessageUtils.mqttProps();
                if (this.includeProblemInfo && !Strings.isNullOrEmpty((String)this.reasonString)) {
                    propsBuilder.addReasonString(this.reasonString);
                }
                if (this.includeProblemInfo && this.userProps != null) {
                    propsBuilder.addUserProperties(this.userProps);
                }
                varHeader = new MqttPubReplyMessageVariableHeader(this.packetId, this.reasonCode.value(), propsBuilder.build());
            }
            return new MqttMessage(fixedHeader, (Object)varHeader);
        }
    }
}

