/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Timed;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basecluster.fd.DirectProbingInfo;
import org.apache.bifromq.basecluster.fd.IFailureDetector;
import org.apache.bifromq.basecluster.fd.IProbingTarget;
import org.apache.bifromq.basecluster.fd.IProbingTargetSelector;
import org.apache.bifromq.basecluster.memberlist.IHostAddressResolver;
import org.apache.bifromq.basecluster.memberlist.IHostMemberList;
import org.apache.bifromq.basecluster.membership.proto.Doubt;
import org.apache.bifromq.basecluster.membership.proto.Endorse;
import org.apache.bifromq.basecluster.membership.proto.Fail;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.membership.proto.HostMember;
import org.apache.bifromq.basecluster.membership.proto.Join;
import org.apache.bifromq.basecluster.membership.proto.Quit;
import org.apache.bifromq.basecluster.messenger.IMessenger;
import org.apache.bifromq.basecluster.messenger.MessageEnvelope;
import org.apache.bifromq.basecluster.proto.ClusterMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoDropper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoDropper.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final IMessenger messenger;
    private final Scheduler scheduler;
    private final IHostMemberList memberList;
    private final IFailureDetector failureDetector;
    private final IHostAddressResolver addressResolver;
    private final Queue<PriorityProbingTarget> probingQueue = new PriorityQueue<PriorityProbingTarget>((a, b) -> Float.compare(a.priority(), b.priority()));
    private final List<PriorityProbingTarget> probingTargets = new ArrayList<PriorityProbingTarget>();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final Map<HostEndpoint, Suspicion> suspicions = new HashMap<HostEndpoint, Suspicion>();
    private final int suspicionMultiplier;
    private final int suspicionMaxTimeoutMultiplier;
    private final Gauge healthScoreGauge;
    private volatile Map<HostEndpoint, Integer> alivePeers = new HashMap<HostEndpoint, Integer>();

    public AutoDropper(IMessenger messenger, Scheduler scheduler, IHostMemberList memberList, IFailureDetector failureDetector, IHostAddressResolver addressResolver, int suspicionMultiplier, int suspicionMaxTimeoutMultiplier, String ... tags) {
        this.messenger = messenger;
        this.scheduler = scheduler;
        this.memberList = memberList;
        this.failureDetector = failureDetector;
        this.addressResolver = addressResolver;
        this.suspicionMultiplier = suspicionMultiplier;
        this.suspicionMaxTimeoutMultiplier = suspicionMaxTimeoutMultiplier;
        this.disposables.add(failureDetector.succeeding().map(Timed::value).observeOn(scheduler).subscribe(this::observeNormalReport));
        this.disposables.add(failureDetector.suspecting().map(Timed::value).observeOn(scheduler).subscribe(this::observeSuspicionReport));
        this.disposables.add(messenger.receive().map(m -> ((MessageEnvelope)m.value()).message).observeOn(scheduler).subscribe(this::handleMessage));
        this.disposables.add(memberList.members().observeOn(scheduler).subscribe(members -> {
            this.alivePeers = Maps.filterKeys((Map)members, k -> !k.equals(memberList.local().getEndpoint()));
        }));
        this.healthScoreGauge = Gauge.builder((String)"basecluster.healthScore", () -> (Number)failureDetector.healthScoring().blockingFirst()).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    public void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            this.failureDetector.start(new IProbingTargetSelector(){

                @Override
                public DirectProbingInfo targetForProbe() {
                    PriorityProbingTarget target = AutoDropper.this.probingQueue.poll();
                    if (target == null) {
                        AutoDropper.this.prepareForProbing();
                    }
                    if ((target = AutoDropper.this.probingQueue.poll()) == null) {
                        return new DirectProbingInfo(Optional.empty(), Collections.emptyList());
                    }
                    if (!AutoDropper.this.alivePeers.containsKey(target.endpoint())) {
                        return this.targetForProbe();
                    }
                    ArrayList<ClusterMessage> piggybacked = new ArrayList<ClusterMessage>();
                    if (AutoDropper.this.suspicions.containsKey(target.endpoint())) {
                        piggybacked.add(ClusterMessage.newBuilder().setDoubt(Doubt.newBuilder().setEndpoint(target.endpoint()).setIncarnation(target.incarnation()).setReporter(AutoDropper.this.memberList.local().getEndpoint()).build()).build());
                    }
                    return new DirectProbingInfo(Optional.of(target), piggybacked);
                }

                @Override
                public Collection<IProbingTarget> targetForIndirectProbes(IProbingTarget skip, int num) {
                    return AutoDropper.this.randomProbingTargets(num, member -> !member.id().equals((Object)skip.id()));
                }
            });
            this.state.set(State.STARTED);
        }
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            this.disposables.dispose();
            this.failureDetector.shutdown();
            Metrics.globalRegistry.remove((Meter)this.healthScoreGauge);
            this.state.set(State.STOPPED);
        }
    }

    private void prepareForProbing() {
        this.probingTargets.clear();
        for (Map.Entry<HostEndpoint, Integer> entry : this.alivePeers.entrySet()) {
            PriorityProbingTarget target = new PriorityProbingTarget(entry.getKey(), entry.getValue());
            this.probingQueue.add(target);
            this.probingTargets.add(target);
        }
    }

    private Collection<IProbingTarget> randomProbingTargets(int limit, Predicate<IProbingTarget> filter) {
        HashSet selected = Sets.newHashSet();
        if (limit >= this.probingTargets.size()) {
            return this.probingTargets.stream().filter(t -> this.alivePeers.containsKey(t.endpoint())).collect(Collectors.toList());
        }
        while (limit > 0) {
            if (limit >= this.probingTargets.size()) {
                return this.randomProbingTargets(limit, filter);
            }
            int randomIdx = ThreadLocalRandom.current().nextInt(this.probingTargets.size());
            PriorityProbingTarget target = this.probingTargets.get(randomIdx);
            if (!this.alivePeers.containsKey(target.endpoint())) {
                this.probingTargets.remove(randomIdx);
                continue;
            }
            if (!filter.test(target)) continue;
            selected.add(target);
            --limit;
        }
        return selected;
    }

    private void observeNormalReport(IProbingTarget healthyTarget) {
        try {
            HostEndpoint endpoint = HostEndpoint.parseFrom(healthyTarget.id());
            Suspicion suspicion = this.suspicions.remove(endpoint);
            if (suspicion != null) {
                suspicion.task.dispose();
                Integer incarnation = this.alivePeers.get(endpoint);
                if (incarnation != null) {
                    this.messenger.spread(ClusterMessage.newBuilder().setEndorse(Endorse.newBuilder().setEndpoint(endpoint).setIncarnation(incarnation).setReporter(this.memberList.local().getEndpoint()).build()).build());
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Unexpected exception", (Throwable)e);
        }
    }

    private void observeSuspicionReport(IProbingTarget suspected) {
        try {
            HostEndpoint suspectedEndpoint = HostEndpoint.parseFrom(suspected.id());
            Integer incarnation = this.alivePeers.get(suspectedEndpoint);
            if (incarnation == null) {
                log.debug("Ignore the suspicion about a non exist member[{}]", (Object)suspectedEndpoint);
                return;
            }
            if (this.suspicions.containsKey(suspectedEndpoint)) {
                log.debug("Member[{}] is already under suspicion", (Object)suspectedEndpoint);
                return;
            }
            log.debug("Got suspicion report[id={}, incarnation={}, reporterId={}] from failure detector", new Object[]{suspectedEndpoint, incarnation, this.memberList.local()});
            Doubt doubt = Doubt.newBuilder().setEndpoint(suspectedEndpoint).setIncarnation(incarnation).setReporter(this.memberList.local().getEndpoint()).build();
            this.startSuspicion(doubt);
            ClusterMessage suspectMsg = ClusterMessage.newBuilder().setDoubt(doubt).build();
            log.debug("Spread the suspicion:\n{}", (Object)doubt);
            this.messenger.spread(suspectMsg);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Unexpected exception", (Throwable)e);
        }
    }

    private void startSuspicion(Doubt doubt) {
        log.debug("Start failure suspicion of member[{},{}] from reporter[{}]: local={}", new Object[]{doubt.getEndpoint(), doubt.getIncarnation(), doubt.getReporter(), this.memberList.local().getEndpoint()});
        HashSet<HostEndpoint> confirmed = new HashSet<HostEndpoint>();
        confirmed.add(doubt.getReporter());
        int k = Math.max(this.probingTargets.size(), 1) < this.suspicionMultiplier ? 0 : this.suspicionMultiplier - 2;
        long minInMS = this.calculateSuspicionTimeout();
        long maxInMS = (long)this.suspicionMaxTimeoutMultiplier * minInMS;
        long start = Instant.now().toEpochMilli();
        Observable suspicionTimer = Observable.create(emitter -> {
            double coe = Math.log10(confirmed.size() + 1) / Math.log10(k + 1);
            long suspicionTimeout = k < 1 ? minInMS : Math.max(minInMS, Math.round((double)maxInMS - (double)(maxInMS - minInMS) * coe));
            long elapsed = Instant.now().toEpochMilli() - start;
            long remaining = suspicionTimeout - elapsed;
            log.debug("Suspicion of member[{},{}] will timeout in {}ms: local={}", new Object[]{doubt.getEndpoint(), doubt.getIncarnation(), remaining, this.memberList.local().getEndpoint()});
            emitter.onNext((Object)remaining);
        }).switchMap(remain -> {
            if (remain > 0L) {
                return Observable.timer((long)remain, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            return Observable.just((Object)0L);
        });
        Observable confirmStream = this.messenger.receive().observeOn(this.scheduler).filter(msg -> {
            ClusterMessage clusterMessage = ((MessageEnvelope)msg.value()).message;
            if (!clusterMessage.hasDoubt()) {
                return false;
            }
            Doubt s = clusterMessage.getDoubt();
            if (s.getEndpoint().equals(doubt.getEndpoint()) && s.getIncarnation() >= doubt.getIncarnation()) {
                if (confirmed.contains(s.getReporter())) {
                    return false;
                }
                if (confirmed.size() < k) {
                    confirmed.add(s.getReporter());
                    if (this.memberList.local().getEndpoint().equals(s.getReporter())) {
                        this.messenger.spread(clusterMessage);
                    }
                    return true;
                }
            }
            return false;
        }).map(msg -> 0L).switchMap(ignore -> Observable.error((Throwable)new RuntimeException("Independent Suspicion Confirm")));
        this.suspicions.put(doubt.getEndpoint(), new Suspicion(doubt.getIncarnation(), Observable.merge((ObservableSource)suspicionTimer, (ObservableSource)confirmStream).retry().observeOn(this.scheduler).subscribe(ignore -> {
            this.suspicions.remove(doubt.getEndpoint());
            log.debug("Suspicion timeout, dead peer[{},{}] confirmed by {} peers: local={}", new Object[]{doubt.getEndpoint(), doubt.getIncarnation(), confirmed.size(), this.memberList.local().getEndpoint()});
            Integer suspectIncarnation = this.alivePeers.get(doubt.getEndpoint());
            if (suspectIncarnation == null) {
                return;
            }
            if (suspectIncarnation <= doubt.getIncarnation()) {
                ClusterMessage msg = this.memberList.isZombie(doubt.getEndpoint()) ? ClusterMessage.newBuilder().setQuit(Quit.newBuilder().setEndpoint(doubt.getEndpoint()).setIncarnation(doubt.getIncarnation()).build()).build() : ClusterMessage.newBuilder().setFail(Fail.newBuilder().setEndpoint(doubt.getEndpoint()).setIncarnation(suspectIncarnation).build()).build();
                log.trace("Spread message: local={}\n{}", (Object)this.memberList.local().getEndpoint(), (Object)msg);
                this.messenger.spread(msg);
            }
        })));
    }

    private void handleMessage(ClusterMessage clusterMessage) {
        switch (clusterMessage.getClusterMessageTypeCase()) {
            case JOIN: {
                this.handleJoin(clusterMessage.getJoin());
                break;
            }
            case QUIT: {
                this.handleQuit(clusterMessage.getQuit());
                break;
            }
            case FAIL: {
                this.handleFail(clusterMessage.getFail());
                break;
            }
            case DOUBT: {
                this.handleDoubt(clusterMessage.getDoubt());
                break;
            }
            case ENDORSE: {
                this.handleEndorse(clusterMessage.getEndorse());
            }
        }
    }

    private void handleJoin(Join join) {
        HostMember joinMember = join.getMember();
        if (this.memberList.isZombie(joinMember.getEndpoint())) {
            return;
        }
        this.stopSuspectIfNeeded(joinMember.getEndpoint(), joinMember.getIncarnation(), true);
    }

    private void handleEndorse(Endorse endorse) {
        HostEndpoint endpoint = endorse.getEndpoint();
        if (this.memberList.isZombie(endpoint)) {
            return;
        }
        this.stopSuspectIfNeeded(endpoint, endorse.getIncarnation(), true);
    }

    private void handleQuit(Quit quit) {
        this.stopSuspectIfNeeded(quit.getEndpoint(), quit.getIncarnation(), false);
    }

    private void handleFail(Fail fail) {
        this.stopSuspectIfNeeded(fail.getEndpoint(), fail.getIncarnation(), false);
    }

    private void stopSuspectIfNeeded(HostEndpoint endpoint, int incarnation, boolean isAlive) {
        Suspicion suspicion = this.suspicions.get(endpoint);
        if (suspicion != null && suspicion.incarnation <= incarnation) {
            if (isAlive) {
                log.debug("Suspected member[{},{}] is alive, stop suspecting it: local={}", new Object[]{endpoint, incarnation, this.memberList.local().getEndpoint()});
            } else {
                log.debug("Suspected member[{},{}] is dead, stop suspecting it: local={}", new Object[]{endpoint, incarnation, this.memberList.local().getEndpoint()});
            }
            this.suspicions.remove(endpoint, suspicion);
            suspicion.task.dispose();
        }
    }

    private void handleDoubt(Doubt doubt) {
        HostEndpoint suspectedEndpoint = doubt.getEndpoint();
        if (this.suspicions.containsKey(doubt.getEndpoint())) {
            if (!doubt.getReporter().equals(this.memberList.local().getEndpoint())) {
                log.debug("Ignore suspect[{},{}] of reporter[{}], member already under suspicion: local={}", new Object[]{suspectedEndpoint, doubt.getIncarnation(), doubt.getReporter(), this.memberList.local().getEndpoint()});
            }
            return;
        }
        Integer suspectedIncarnation = this.alivePeers.get(suspectedEndpoint);
        if (suspectedIncarnation == null) {
            log.debug("Ignore suspect[{},{}] by member[{}], no member found: local={}", new Object[]{doubt.getEndpoint(), doubt.getIncarnation(), doubt.getReporter(), this.memberList.local().getEndpoint()});
            return;
        }
        if (doubt.getIncarnation() < suspectedIncarnation) {
            log.debug("Ignore suspect[{},{}] by member[{}], obsolete incarnation: local={}", new Object[]{doubt.getEndpoint(), doubt.getIncarnation(), doubt.getReporter(), this.memberList.local().getEndpoint()});
            return;
        }
        if (this.memberList.local().getEndpoint().equals(doubt.getEndpoint())) {
            log.debug("Receive suspicion from others, penalty health: local={}", (Object)this.memberList.local().getEndpoint());
            this.failureDetector.penaltyHealth();
        } else {
            this.startSuspicion(doubt);
        }
    }

    private int clusterSize() {
        return Math.max(this.probingTargets.size(), 1);
    }

    private long calculateSuspicionTimeout() {
        double scale = Math.max(1.0, Math.log10(Math.max((double)this.clusterSize(), 1.0)));
        return Math.round((double)this.suspicionMultiplier * scale * (double)this.failureDetector.baseProbeInterval().toMillis());
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    private class PriorityProbingTarget
    implements IProbingTarget {
        final float p = ThreadLocalRandom.current().nextFloat();
        private final HostEndpoint endpoint;
        private final int incarnation;
        private final InetSocketAddress address;

        PriorityProbingTarget(HostEndpoint endpoint, int incarnation) {
            this.endpoint = endpoint;
            this.incarnation = incarnation;
            this.address = AutoDropper.this.addressResolver.resolve(endpoint);
        }

        public float priority() {
            return this.p;
        }

        public HostMember member() {
            return HostMember.newBuilder().setEndpoint(this.endpoint).setIncarnation(this.incarnation).build();
        }

        public HostEndpoint endpoint() {
            return this.endpoint;
        }

        public int incarnation() {
            return this.incarnation;
        }

        @Override
        public ByteString id() {
            return this.endpoint.toByteString();
        }

        @Override
        public InetSocketAddress addr() {
            return this.address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PriorityProbingTarget)) {
                return false;
            }
            PriorityProbingTarget other = (PriorityProbingTarget)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.incarnation != other.incarnation) {
                return false;
            }
            HostEndpoint this$endpoint = this.endpoint;
            HostEndpoint other$endpoint = other.endpoint;
            if (this$endpoint == null ? other$endpoint != null : !((Object)this$endpoint).equals(other$endpoint)) {
                return false;
            }
            InetSocketAddress this$address = this.address;
            InetSocketAddress other$address = other.address;
            return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PriorityProbingTarget;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.incarnation;
            HostEndpoint $endpoint = this.endpoint;
            result = result * 59 + ($endpoint == null ? 43 : ((Object)$endpoint).hashCode());
            InetSocketAddress $address = this.address;
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            return result;
        }
    }

    private static class Suspicion {
        final int incarnation;
        final Disposable task;

        @Generated
        public Suspicion(int incarnation, Disposable task) {
            this.incarnation = incarnation;
            this.task = task;
        }
    }
}

