/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import org.apache.commons.lang3.Validate;

public class Ipv4Address
extends IpAddress {
    private static final long serialVersionUID = 2L;
    private static final int BYTE_MASK = 255;
    public static final int NUMBER_OF_BITS = 32;
    private static final long MINIMUM_VALUE = 0L;
    private static final long MAXIMUM_VALUE = 0xFFFFFFFFL;
    private int intValue;

    @Deprecated
    public Ipv4Address(BigInteger value) {
        this(value.longValue());
    }

    public Ipv4Address(long value) {
        Validate.isTrue((value >= 0L && value <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"value out of range", (Object[])new Object[0]);
        this.intValue = (int)value;
    }

    @Override
    public IpResourceType getType() {
        return IpResourceType.IPv4;
    }

    public static Ipv4Address parse(String s) {
        return Ipv4Address.parse(s, false);
    }

    public static Ipv4Address parse(String s, boolean defaultMissingOctets) {
        int length = (s = s.trim()).length();
        if (length == 0 || !Character.isDigit(s.charAt(0)) || !Character.isDigit(s.charAt(s.length() - 1))) {
            throw new IllegalArgumentException("invalid IPv4 address: " + s);
        }
        long value = 0L;
        int octet = 0;
        int octetCount = 1;
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (Character.isDigit(ch)) {
                octet = octet * 10 + (ch - 48);
                continue;
            }
            if (ch == '.') {
                if (octetCount > 4) {
                    throw new IllegalArgumentException("invalid IPv4 address: " + s);
                }
                ++octetCount;
                value = Ipv4Address.addOctet(value, octet);
                octet = 0;
                continue;
            }
            throw new IllegalArgumentException("invalid IPv4 address: " + s);
        }
        value = Ipv4Address.addOctet(value, octet);
        if (defaultMissingOctets) {
            value <<= (int)(8L * (long)(4 - octetCount));
        } else if (octetCount != 4) {
            throw new IllegalArgumentException("invalid IPv4 address: " + s);
        }
        return new Ipv4Address(value);
    }

    private static long addOctet(long value, int octet) {
        if (octet < 0 || octet > 255) {
            throw new IllegalArgumentException("value of octet not in range 0..255: " + octet);
        }
        value = value << 8 | (long)octet;
        return value;
    }

    @Override
    public String toString(boolean defaultMissingOctets) {
        long value = this.getValue().longValue();
        int a = (int)(value >> 24);
        int b = (int)(value >> 16) & 0xFF;
        int c = (int)(value >> 8) & 0xFF;
        int d = (int)value & 0xFF;
        if (!defaultMissingOctets) {
            return a + "." + b + "." + c + "." + d;
        }
        if (b == 0 && c == 0 && d == 0) {
            return "" + a;
        }
        if (c == 0 && d == 0) {
            return a + "." + b;
        }
        if (d == 0) {
            return a + "." + b + "." + c;
        }
        return a + "." + b + "." + c + "." + d;
    }

    public long longValue() {
        return this.value();
    }

    @Override
    protected int doHashCode() {
        return this.intValue;
    }

    @Override
    protected int doCompareTo(IpResource obj) {
        if (obj instanceof Ipv4Address) {
            long otherValue = ((Ipv4Address)obj).value();
            return Long.compare(this.value(), otherValue);
        }
        return super.doCompareTo(obj);
    }

    @Override
    public final BigInteger getValue() {
        return BigInteger.valueOf(this.value());
    }

    @Override
    protected boolean adjacent(UniqueIpResource other) {
        return other instanceof Ipv4Address && Math.abs(this.longValue() - ((Ipv4Address)other).longValue()) == 1L;
    }

    @Override
    public int getCommonPrefixLength(UniqueIpResource other) {
        Validate.isTrue((this.getType() == other.getType() ? 1 : 0) != 0, (String)"incompatible resource types", (Object[])new Object[0]);
        long temp = this.value() ^ ((Ipv4Address)other).value();
        return Integer.numberOfLeadingZeros((int)temp);
    }

    @Override
    public Ipv4Address lowerBoundForPrefix(int prefixLength) {
        long mask = (1L << 32 - prefixLength) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return new Ipv4Address(this.value() & mask);
    }

    @Override
    public Ipv4Address upperBoundForPrefix(int prefixLength) {
        long mask = (1L << 32 - prefixLength) - 1L;
        return new Ipv4Address(this.value() | mask);
    }

    @Override
    public boolean isValidNetmask() {
        int leadingOnesCount = Integer.numberOfLeadingZeros(~((int)this.value()));
        int trailingZeroesCount = Integer.numberOfTrailingZeros((int)this.value());
        return leadingOnesCount > 0 && leadingOnesCount + trailingZeroesCount == 32;
    }

    private long value() {
        return (long)this.intValue & 0xFFFFFFFFL;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        this.intValue = !gf.defaulted("intValue") ? gf.get("intValue", 0) : (int)gf.get("value", 0L);
    }
}

