/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geopackage;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageManager;
import org.apache.baremaps.geopackage.GeoPackageDataTable;
import org.apache.baremaps.store.DataStore;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;

public class GeoPackageDataStore
implements DataStore,
AutoCloseable {
    private final GeoPackage geoPackage;

    public GeoPackageDataStore(Path file) {
        this.geoPackage = GeoPackageManager.open((File)file.toFile());
    }

    @Override
    public void close() throws Exception {
        this.geoPackage.close();
    }

    public List<String> list() throws DataStoreException {
        return this.geoPackage.getFeatureTables();
    }

    public DataTable get(String name) throws DataStoreException {
        return new GeoPackageDataTable(this.geoPackage.getFeatureDao(name));
    }

    public void add(DataTable table) throws DataStoreException {
        throw new UnsupportedOperationException();
    }

    public void add(String name, DataTable table) throws DataStoreException {
        throw new UnsupportedOperationException();
    }

    public void remove(String name) throws DataStoreException {
        throw new UnsupportedOperationException();
    }
}

