/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.LogRecord;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.geotiff.GeoTiffStoreProvider;
import org.apache.sis.storage.geotiff.NativeMetadata;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.spi.SchemaModifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.ListOfUnknownSize;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class GeoTiffStore
extends DataStore
implements Aggregate {
    final Charset encoding;
    private volatile Reader reader;
    private final URI location;
    final Path path;
    private NameSpace namespace;
    private boolean isNamespaceSet;
    private Metadata metadata;
    private TreeTable nativeMetadata;
    private List<GridCoverageResource> components;
    final boolean hidden;
    final SchemaModifier customizer;

    public GeoTiffStore(GeoTiffStoreProvider provider, StorageConnector connector) throws DataStoreException {
        this(null, provider, connector, false);
    }

    public GeoTiffStore(DataStore parent, DataStoreProvider provider, StorageConnector connector, boolean hidden) throws DataStoreException {
        super(parent, provider, connector, hidden);
        this.hidden = hidden;
        SchemaModifier customizer = (SchemaModifier)connector.getOption(SchemaModifier.OPTION);
        this.customizer = customizer != null ? customizer : SchemaModifier.DEFAULT;
        Charset encoding = (Charset)connector.getOption(OptionKey.ENCODING);
        this.encoding = encoding != null ? encoding : StandardCharsets.US_ASCII;
        this.location = (URI)connector.getStorageAs(URI.class);
        this.path = (Path)connector.getStorageAs(Path.class);
        ChannelDataInput input = (ChannelDataInput)connector.commit(ChannelDataInput.class, "GeoTIFF");
        try {
            this.reader = new Reader(this, input);
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
        if (((Object)((Object)this)).getClass() == GeoTiffStore.class) {
            this.listeners.useReadOnlyEvents();
        }
    }

    final NameSpace namespace() {
        Reader reader = this.reader;
        if (!this.isNamespaceSet && reader != null) {
            NameFactory f = reader.nameFactory;
            GenericName name = null;
            if (this.location != null) {
                String filename = IOUtilities.filenameWithoutExtension((String)reader.input.filename);
                name = f.createLocalName(null, (CharSequence)filename);
            }
            if ((name = this.customizer.customize(-1, name)) != null) {
                this.namespace = f.createNameSpace(name, null);
            }
            this.isNamespaceSet = true;
        }
        return this.namespace;
    }

    final StoreListeners listeners() {
        return this.listeners;
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters((DataStoreProvider)this.provider, (URI)this.location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        NameSpace namespace;
        GeoTiffStore geoTiffStore = this;
        synchronized (geoTiffStore) {
            namespace = this.namespace();
        }
        return namespace != null ? Optional.of(namespace.name()) : Optional.empty();
    }

    final void setFormatInfo(MetadataBuilder builder) {
        try {
            builder.setPredefinedFormat("GeoTIFF");
        }
        catch (MetadataStoreException e) {
            builder.addFormatName((CharSequence)"GeoTIFF");
            this.listeners.warning((Exception)((Object)e));
        }
        builder.addLanguage(Locale.ENGLISH, this.encoding, MetadataBuilder.Scope.METADATA);
        builder.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            Reader reader = this.reader();
            MetadataBuilder builder = new MetadataBuilder();
            this.setFormatInfo(builder);
            int n = 0;
            try {
                GridCoverageResource dir;
                while ((dir = reader.getImage(n++)) != null) {
                    builder.addFromComponent(dir.getMetadata());
                }
            }
            catch (IOException e) {
                throw this.errorIO(e);
            }
            catch (ArithmeticException e) {
                this.listeners.warning((Exception)e);
            }
            this.getIdentifier().ifPresent(id -> builder.addTitleOrIdentifier(id.toString(), MetadataBuilder.Scope.ALL));
            builder.setISOStandards(true);
            DefaultMetadata md = builder.build();
            this.metadata = this.customizer.customize(-1, md);
            if (this.metadata == null) {
                this.metadata = md;
            }
            md.transitionTo(ModifiableMetadata.State.FINAL);
        }
        return this.metadata;
    }

    public synchronized Optional<TreeTable> getNativeMetadata() throws DataStoreException {
        if (this.nativeMetadata == null) {
            try {
                this.nativeMetadata = new NativeMetadata(this.getLocale()).read(this.reader());
            }
            catch (IOException e) {
                throw this.errorIO(e);
            }
        }
        return Optional.of(this.nativeMetadata);
    }

    final DataStoreException errorIO(IOException e) {
        return new DataStoreException(this.errors().getString((short)12, (Object)this.reader.input.filename), (Throwable)e);
    }

    private Reader reader() throws DataStoreException {
        assert (Thread.holdsLock((Object)this));
        Reader r = this.reader;
        if (r == null) {
            throw new DataStoreClosedException(this.getLocale(), "GeoTIFF", new OpenOption[]{StandardOpenOption.READ});
        }
        return r;
    }

    public synchronized List<GridCoverageResource> components() throws DataStoreException {
        if (this.components == null) {
            this.components = new Components();
        }
        return this.components;
    }

    public synchronized GridCoverageResource findResource(String sequence) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"sequence", (Object)sequence);
        int index = this.parseImageIndex(sequence);
        if (index >= 0) {
            try {
                GridCoverageResource image = this.reader().getImage(index - 1);
                if (image != null) {
                    return image;
                }
            }
            catch (IOException e) {
                throw this.errorIO(e);
            }
        }
        throw new IllegalNameException(StoreUtilities.resourceNotFound((DataStore)this, (String)sequence));
    }

    private int parseImageIndex(String sequence) throws IllegalNameException {
        NameSpace namespace = this.namespace();
        String separator = DefaultNameSpace.getSeparator((NameSpace)namespace, (boolean)false);
        int s = sequence.lastIndexOf(separator);
        if (s >= 0) {
            if (namespace != null) {
                String expected = namespace.name().toString();
                if (!sequence.substring(0, s).equals(expected)) {
                    throw new IllegalNameException(this.errors().getString((short)68, (Object)expected, (Object)sequence));
                }
            }
            sequence = sequence.substring(s + separator.length());
        }
        try {
            return Integer.parseInt(sequence);
        }
        catch (NumberFormatException e) {
            throw new IllegalNameException(StoreUtilities.resourceNotFound((DataStore)this, (String)sequence), (Throwable)e);
        }
    }

    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DataStoreException {
        try {
            this.listeners.close();
            Object r = this.reader;
            if (r != null) {
                r.close();
            }
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
        finally {
            GeoTiffStore geoTiffStore = this;
            synchronized (geoTiffStore) {
                this.components = null;
                this.namespace = null;
                this.metadata = null;
                this.nativeMetadata = null;
                this.reader = null;
            }
        }
    }

    final Errors errors() {
        return Errors.getResources((Locale)this.getLocale());
    }

    final void warning(LogRecord record) {
        record.setSourceClassName(GeoTiffStore.class.getName());
        record.setSourceMethodName("getMetadata");
        this.listeners.warning(record);
    }

    private final class Components
    extends ListOfUnknownSize<GridCoverageResource> {
        private int size = -1;

        private Components() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int sizeIfKnown() {
            GeoTiffStore geoTiffStore = GeoTiffStore.this;
            synchronized (geoTiffStore) {
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            GeoTiffStore geoTiffStore = GeoTiffStore.this;
            synchronized (geoTiffStore) {
                if (this.size < 0) {
                    this.size = super.size();
                }
                return this.size;
            }
        }

        protected boolean exists(int index) {
            return index >= 0 && this.getImageFileDirectory(index) != null;
        }

        public GridCoverageResource get(int index) {
            GridCoverageResource image;
            if (index >= 0 && (image = this.getImageFileDirectory(index)) != null) {
                return image;
            }
            throw new IndexOutOfBoundsException(GeoTiffStore.this.errors().getString((short)71, (Object)index));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GridCoverageResource getImageFileDirectory(int index) {
            try {
                GeoTiffStore geoTiffStore = GeoTiffStore.this;
                synchronized (geoTiffStore) {
                    return GeoTiffStore.this.reader().getImage(index);
                }
            }
            catch (IOException e) {
                throw new BackingStoreException((Throwable)GeoTiffStore.this.errorIO(e));
            }
            catch (DataStoreException e) {
                throw new BackingStoreException((Throwable)e);
            }
        }
    }
}

