/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.iploc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.docs.DocService;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import org.apache.baremaps.iploc.IpLocRepository;
import org.apache.baremaps.server.IpLocResource;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start an IP to location web service."})
public class Serve
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Serve.class);
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The path of the SQLite database."}, defaultValue="iploc.db")
    private Path database;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        String jdbcUrl = String.format("JDBC:sqlite:%s", this.database.toString());
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(jdbcUrl);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        HikariDataSource dataSource = new HikariDataSource(config);
        IpLocRepository ipLocRepository = new IpLocRepository((DataSource)dataSource);
        ServerBuilder serverBuilder = Server.builder();
        serverBuilder.http(this.port);
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        JacksonResponseConverterFunction jsonResponseConverter = new JacksonResponseConverterFunction(objectMapper);
        serverBuilder.annotatedService((Object)new IpLocResource(ipLocRepository), new Object[]{jsonResponseConverter});
        HttpFile index = HttpFile.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/iploc/index.html");
        serverBuilder.service("/", index.asService());
        serverBuilder.serviceUnder("/", (HttpService)FileService.of((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"/iploc"));
        serverBuilder.decorator(CorsService.builderForAnyOrigin().allowRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.OPTIONS, HttpMethod.HEAD}).allowRequestHeaders(new CharSequence[]{HttpHeaderNames.ORIGIN, HttpHeaderNames.CONTENT_TYPE, HttpHeaderNames.ACCEPT, HttpHeaderNames.AUTHORIZATION}).allowCredentials().exposeHeaders(new CharSequence[]{HttpHeaderNames.LOCATION}).newDecorator());
        serverBuilder.serviceUnder("/docs", (HttpService)new DocService());
        serverBuilder.disableServerHeader();
        serverBuilder.disableDateHeader();
        Server server = serverBuilder.build();
        CompletableFuture startFuture = server.start();
        startFuture.join();
        CompletableFuture shutdownFuture = server.closeOnJvmShutdown();
        shutdownFuture.join();
        return 0;
    }
}

