/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.raster;

import java.awt.Dimension;
import java.nio.DoubleBuffer;
import org.apache.sis.image.Interpolation;

class BicubicInterpolation
extends Interpolation {
    BicubicInterpolation() {
    }

    public Dimension getSupportSize() {
        return new Dimension(4, 4);
    }

    public void interpolate(DoubleBuffer source, int numBands, double xfrac, double yfrac, double[] writeTo, int writeToOffset) {
        double[] colValues = new double[4];
        double[] rowValues = new double[4];
        for (int band = 0; band < numBands; ++band) {
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 4; ++i) {
                    rowValues[i] = source.get(band + i * numBands + j * numBands * 4);
                }
                colValues[j] = this.cubicInterpolate(rowValues, xfrac);
            }
            writeTo[writeToOffset + band] = this.cubicInterpolate(colValues, yfrac);
        }
    }

    private double cubicInterpolate(double[] p, double x) {
        return p[1] + 0.5 * x * (p[2] - p[0] + x * (2.0 * p[0] - 5.0 * p[1] + 4.0 * p[2] - p[3] + x * (3.0 * (p[1] - p[2]) + p[3] - p[0])));
    }
}

