/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.spi.LoggingSystemProperty;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.InternalException;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyKey;

@InternalApi
public final class LoaderUtil {
    private static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    private static Boolean ignoreTCCL;
    static Boolean forceTcclOnly;

    private LoaderUtil() {
    }

    public static ClassLoader getClassLoader() {
        return LoaderUtil.getClassLoader(LoaderUtil.class, null);
    }

    public static ClassLoader getClassLoader(Class<?> class1, Class<?> class2) {
        ClassLoader loader1 = class1 == null ? null : class1.getClassLoader();
        ClassLoader loader2 = class2 == null ? null : class2.getClassLoader();
        ClassLoader referenceLoader = Thread.currentThread().getContextClassLoader();
        if (LoaderUtil.isChild(referenceLoader, loader1)) {
            return LoaderUtil.isChild(referenceLoader, loader2) ? referenceLoader : loader2;
        }
        return LoaderUtil.isChild(loader1, loader2) ? loader1 : loader2;
    }

    private static boolean isChild(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 != null && loader2 != null) {
            ClassLoader parent;
            for (parent = loader1.getParent(); parent != null && parent != loader2; parent = parent.getParent()) {
            }
            return parent != null;
        }
        return loader1 != null;
    }

    public static ClassLoader getThreadContextClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader thisClassLoader = LoaderUtil.getThisClassLoader();
        if (thisClassLoader != null) {
            return thisClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public static ClassLoader[] getClassLoaders() {
        LinkedHashSet<ClassLoader> classLoaders;
        block4: {
            ModuleLayer layer;
            block3: {
                classLoaders = new LinkedHashSet<ClassLoader>();
                ClassLoader tcl = LoaderUtil.getThreadContextClassLoader();
                if (tcl != null) {
                    classLoaders.add(tcl);
                }
                if ((layer = LoaderUtil.class.getModule().getLayer()) != null) break block3;
                if (LoaderUtil.isForceTccl()) break block4;
                LoaderUtil.accumulateClassLoaders(LoaderUtil.getThisClassLoader(), classLoaders);
                LoaderUtil.accumulateClassLoaders(tcl == null ? null : tcl.getParent(), classLoaders);
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                if (systemClassLoader == null) break block4;
                classLoaders.add(systemClassLoader);
                break block4;
            }
            LoaderUtil.accumulateLayerClassLoaders(layer, classLoaders);
            if (layer != ModuleLayer.boot()) {
                for (Module module : ModuleLayer.boot().modules()) {
                    LoaderUtil.accumulateClassLoaders(module.getClassLoader(), classLoaders);
                }
            }
        }
        return classLoaders.toArray(EMPTY_CLASS_LOADER_ARRAY);
    }

    private static ClassLoader getThisClassLoader() {
        return LoaderUtil.class.getClassLoader();
    }

    private static void accumulateLayerClassLoaders(ModuleLayer layer, Collection<ClassLoader> classLoaders) {
        for (Module module : layer.modules()) {
            LoaderUtil.accumulateClassLoaders(module.getClassLoader(), classLoaders);
        }
        if (!layer.parents().isEmpty()) {
            for (ModuleLayer parent : layer.parents()) {
                LoaderUtil.accumulateLayerClassLoaders(parent, classLoaders);
            }
        }
    }

    private static void accumulateClassLoaders(ClassLoader loader, Collection<ClassLoader> loaders) {
        if (loader != null && loaders.add(loader)) {
            LoaderUtil.accumulateClassLoaders(loader.getParent(), loaders);
        }
    }

    public static boolean isClassAvailable(String className) {
        try {
            LoaderUtil.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
        catch (Throwable e) {
            LowLevelLogUtil.logException("Unknown error checking for existence of class: " + className, e);
            return false;
        }
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = LoaderUtil.isIgnoreTccl() ? LoaderUtil.getThisClassLoader() : LoaderUtil.getThreadContextClassLoader();
        if (classLoader == null) {
            classLoader = LoaderUtil.getThisClassLoader();
        }
        return Class.forName(className, true, classLoader);
    }

    public static Class<?> loadClassUnchecked(String className) {
        try {
            return LoaderUtil.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            NoClassDefFoundError error = new NoClassDefFoundError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public static <T> T newInstanceOf(Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    public static <T> T newInstanceOfUnchecked(Class<T> clazz) {
        try {
            return LoaderUtil.newInstanceOf(clazz);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError error = new NoSuchMethodError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new InternalException(cause);
        }
        catch (InstantiationException e) {
            InstantiationError error = new InstantiationError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public static <T> T newInstanceOf(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Class clazz = (Class)Cast.cast(LoaderUtil.loadClass(className));
        return LoaderUtil.newInstanceOf(clazz);
    }

    public static <T> T newCheckedInstanceOfProperty(PropertyKey propertyKey, Class<T> clazz, Supplier<T> defaultSupplier) throws ReflectiveOperationException {
        String className = PropertiesUtil.getProperties().getStringProperty(propertyKey);
        if (className == null) {
            return defaultSupplier.get();
        }
        return LoaderUtil.newCheckedInstanceOf(className, clazz);
    }

    public static <T> T newInstanceOfUnchecked(String className) {
        Class clazz = (Class)Cast.cast(LoaderUtil.loadClassUnchecked(className));
        return LoaderUtil.newInstanceOfUnchecked(clazz);
    }

    public static <T> T newCheckedInstanceOf(String className, Class<T> clazz) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        return LoaderUtil.newInstanceOf(LoaderUtil.loadClass(className).asSubclass(clazz));
    }

    public static <T> T newInstanceOfUnchecked(String className, Class<T> supertype) {
        Class<T> clazz = LoaderUtil.loadClassUnchecked(className).asSubclass(supertype);
        return LoaderUtil.newInstanceOfUnchecked(clazz);
    }

    private static boolean isIgnoreTccl() {
        if (ignoreTCCL == null) {
            String ignoreTccl = PropertiesUtil.getProperties().getStringProperty(LoggingSystemProperty.LOADER_IGNORE_THREAD_CONTEXT_LOADER, null);
            ignoreTCCL = ignoreTccl != null && !"false".equalsIgnoreCase(ignoreTccl.trim());
        }
        return ignoreTCCL;
    }

    private static boolean isForceTccl() {
        if (forceTcclOnly == null) {
            forceTcclOnly = Boolean.getBoolean(LoggingSystemProperty.LOADER_FORCE_THREAD_CONTEXT_LOADER.getSystemKey());
        }
        return forceTcclOnly;
    }

    public static Collection<URL> findResources(String resource) {
        Collection<UrlResource> urlResources = LoaderUtil.findUrlResources(resource);
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(urlResources.size());
        for (UrlResource urlResource : urlResources) {
            resources.add(urlResource.getUrl());
        }
        return resources;
    }

    public static Collection<UrlResource> findUrlResources(String resource) {
        LinkedHashSet<UrlResource> resources = new LinkedHashSet<UrlResource>();
        for (ClassLoader cl : LoaderUtil.getClassLoaders()) {
            if (cl == null) continue;
            try {
                Enumeration<URL> resourceEnum = cl.getResources(resource);
                while (resourceEnum.hasMoreElements()) {
                    resources.add(new UrlResource(cl, resourceEnum.nextElement()));
                }
            }
            catch (IOException e) {
                LowLevelLogUtil.logException(e);
            }
        }
        return resources;
    }

    static {
        if (System.getSecurityManager() != null) {
            LowLevelLogUtil.log("A custom SecurityManager was detected; Log4j no longer supports security permissions.");
        }
    }

    public static class UrlResource {
        private final ClassLoader classLoader;
        private final URL url;

        public UrlResource(ClassLoader classLoader, URL url) {
            this.classLoader = classLoader;
            this.url = url;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrlResource)) {
                return false;
            }
            UrlResource that = (UrlResource)o;
            return Objects.equals(this.classLoader, that.classLoader) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hashCode(this.classLoader) + Objects.hashCode(this.url);
        }
    }
}

