/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.HashMap;
import java.util.Map;

public enum CoordinateSystemType {
    AFFINE("affine"),
    CARTESIAN("Cartesian"),
    CYLINDRICAL("cylindrical"),
    ELLIPSOIDAL("ellipsoidal"),
    LINEAR("linear"),
    ORDINAL("ordinal"),
    PARAMETRIC("parametric"),
    POLAR("polar"),
    SPHERICAL("spherical"),
    TEMPORAL_COUNT("temporalCount"),
    TEMPORAL_DATE_TIME("temporalDateTime"),
    TEMPORAL_MEASURE("temporalMeasure"),
    VERTICAL("vertical");

    private static final Map<String, CoordinateSystemType> nameTypes;
    private final String name;

    private CoordinateSystemType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static CoordinateSystemType getType(String name) {
        CoordinateSystemType type = null;
        if (name != null) {
            type = nameTypes.get(name.toUpperCase());
        }
        return type;
    }

    static {
        nameTypes = new HashMap<String, CoordinateSystemType>();
        for (CoordinateSystemType type : CoordinateSystemType.values()) {
            nameTypes.put(type.getName().toUpperCase(), type);
        }
    }
}

