/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.UUID;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilObjectHandler;
import org.apache.sis.xml.XLink;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gcx.Anchor;
import org.opengis.metadata.Identifier;

public class ReferenceResolver {
    public static final ReferenceResolver DEFAULT = new ReferenceResolver();

    protected ReferenceResolver() {
    }

    public <T> T newIdentifiedObject(MarshalContext context, Class<T> type, Identifier ... identifiers) {
        if (NilObjectHandler.isIgnoredInterface(type)) {
            throw new IllegalArgumentException(Errors.format((short)45, (Object)"type", type));
        }
        return (T)Proxy.newProxyInstance(ReferenceResolver.class.getClassLoader(), new Class[]{type, IdentifiedObject.class, NilObject.class, LenientComparable.class}, (InvocationHandler)new NilObjectHandler(identifiers));
    }

    public <T> T resolve(MarshalContext context, Class<T> type, UUID uuid) {
        ArgumentChecks.ensureNonNull((String)"type", type);
        ArgumentChecks.ensureNonNull((String)"uuid", (Object)uuid);
        return null;
    }

    public <T> T resolve(MarshalContext context, Class<T> type, XLink link) {
        ArgumentChecks.ensureNonNull((String)"type", type);
        ArgumentChecks.ensureNonNull((String)"xlink", (Object)link);
        URI href = link.getHRef();
        if (href != null && href.toString().startsWith("#")) {
            Object[] args;
            short key;
            String id;
            Context c = context instanceof Context ? (Context)context : Context.current();
            Object object = Context.getObjectForID(c, id = href.getFragment());
            if (type.isInstance(object)) {
                return type.cast(object);
            }
            if (object == null) {
                key = 108;
                args = new Object[]{id};
            } else {
                key = 143;
                args = new Object[]{id, type, object.getClass()};
            }
            Context.warningOccured(c, ReferenceResolver.class, "resolve", Errors.class, key, args);
        }
        return null;
    }

    public <T> boolean canSubstituteByReference(MarshalContext context, Class<T> type, T object, String id) {
        return true;
    }

    public <T> boolean canSubstituteByReference(MarshalContext context, Class<T> type, T object, UUID uuid) {
        return object instanceof NilObject || object instanceof Emptiable && ((Emptiable)object).isEmpty();
    }

    public <T> boolean canSubstituteByReference(MarshalContext context, Class<T> type, T object, XLink link) {
        return object instanceof NilObject || object instanceof Emptiable && ((Emptiable)object).isEmpty();
    }

    public XLink anchor(MarshalContext context, Object value, CharSequence text) {
        return text instanceof Anchor ? (Anchor)((Object)text) : null;
    }
}

