/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.io.SQLExec;
import mil.nga.geopackage.io.SQLExecResult;

public class SQLExecAlterTable {
    private static final String REGEX_PREFIX = "(?i)(?s)^";
    private static final String REGEX_NAME = "(\".+\"|\\S+)";
    private static final String REGEX_ALTER_TABLE = "(?i)(?s)^ALTER\\s+TABLE\\s+(\".+\"|\\S+)\\s+";
    public static final Pattern ALTER_TABLE_PATTERN = Pattern.compile("(?i)(?s)^ALTER\\s+TABLE\\s+(\".+\"|\\S+)\\s+.+");
    public static final Pattern DROP_COLUMN_PATTERN = Pattern.compile("(?i)(?s)^ALTER\\s+TABLE\\s+(\".+\"|\\S+)\\s+DROP(\\s+COLUMN)?\\s+(\".+\"|\\S+)");
    public static final Pattern RENAME_TABLE_PATTERN = Pattern.compile("(?i)(?s)^ALTER\\s+TABLE\\s+(\".+\"|\\S+)\\s+RENAME\\s+TO\\s+(\".+\"|\\S+)");
    public static final Pattern COPY_TABLE_PATTERN = Pattern.compile("(?i)(?s)^ALTER\\s+TABLE\\s+(\".+\"|\\S+)\\s+COPY\\s+TO\\s+(\".+\"|\\S+)");
    public static final int TABLE_NAME_GROUP = 1;
    public static final int COLUMN_NAME_GROUP = 3;
    public static final int NEW_TABLE_NAME_GROUP = 2;
    public static final Pattern DROP_TABLE_PATTERN = Pattern.compile("(?i)(?s)^DROP\\s+TABLE\\s+(\".+\"|\\S+)");

    public static SQLExecResult alterTable(GeoPackage database, String sql) {
        SQLExecResult result = null;
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if (ALTER_TABLE_PATTERN.matcher(sql).matches()) {
            result = SQLExecAlterTable.dropColumn(database, sql);
            if (result == null && (result = SQLExecAlterTable.renameTable(database, sql)) == null) {
                result = SQLExecAlterTable.copyTable(database, sql);
            }
        } else {
            result = SQLExecAlterTable.dropTable(database, sql);
        }
        return result;
    }

    private static SQLExecResult dropColumn(GeoPackage database, String sql) {
        SQLExecResult result = null;
        Matcher matcher = DROP_COLUMN_PATTERN.matcher(sql);
        if (matcher.find()) {
            String columnName;
            String tableName = CoreSQLUtils.quoteUnwrap((String)matcher.group(1));
            if (tableName != null) {
                tableName = tableName.trim();
            }
            if ((columnName = CoreSQLUtils.quoteUnwrap((String)matcher.group(3))) != null) {
                columnName = columnName.trim();
            }
            if (tableName != null && columnName != null) {
                AlterTable.dropColumn((GeoPackageCoreConnection)database.getDatabase(), (String)tableName, (String)columnName);
                result = new SQLExecResult();
            }
        }
        return result;
    }

    private static SQLExecResult renameTable(GeoPackage database, String sql) {
        SQLExecResult result = null;
        Matcher matcher = RENAME_TABLE_PATTERN.matcher(sql);
        if (matcher.find() && SQLExec.isGeoPackage(database)) {
            String newTableName;
            String tableName = CoreSQLUtils.quoteUnwrap((String)matcher.group(1));
            if (tableName != null) {
                tableName = tableName.trim();
            }
            if ((newTableName = CoreSQLUtils.quoteUnwrap((String)matcher.group(2))) != null) {
                newTableName = newTableName.trim();
            }
            if (tableName != null && newTableName != null && database.getTableDataType(tableName) != null) {
                database.renameTable(tableName, newTableName);
                result = new SQLExecResult();
            }
        }
        return result;
    }

    private static SQLExecResult copyTable(GeoPackage database, String sql) {
        SQLExecResult result = null;
        Matcher matcher = COPY_TABLE_PATTERN.matcher(sql);
        if (matcher.find()) {
            String newTableName;
            String tableName = CoreSQLUtils.quoteUnwrap((String)matcher.group(1));
            if (tableName != null) {
                tableName = tableName.trim();
            }
            if ((newTableName = CoreSQLUtils.quoteUnwrap((String)matcher.group(2))) != null) {
                newTableName = newTableName.trim();
            }
            if (tableName != null && newTableName != null) {
                if (SQLExec.isGeoPackage(database)) {
                    database.copyTable(tableName, newTableName);
                } else {
                    AlterTable.copyTable((GeoPackageCoreConnection)database.getDatabase(), (String)tableName, (String)newTableName);
                }
                result = new SQLExecResult();
            }
        }
        return result;
    }

    private static SQLExecResult dropTable(GeoPackage database, String sql) {
        String tableName;
        SQLExecResult result = null;
        Matcher matcher = DROP_TABLE_PATTERN.matcher(sql);
        if (matcher.matches() && SQLExec.isGeoPackage(database) && (tableName = CoreSQLUtils.quoteUnwrap((String)matcher.group(1))) != null) {
            if (!database.isTable(tableName = tableName.trim())) {
                throw new GeoPackageException("Table does not exist: " + tableName);
            }
            database.deleteTable(tableName.trim());
            result = new SQLExecResult();
        }
        return result;
    }
}

