/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.baremaps.geoparquet.GeoParquetGroup;
import org.apache.baremaps.geoparquet.GeoParquetSchema;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataColumnFixed;
import org.apache.baremaps.store.DataColumnNested;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataSchemaImpl;
import org.apache.parquet.io.api.Binary;

public class GeoParquetTypeConversion {
    private GeoParquetTypeConversion() {
    }

    public static DataSchema asSchema(String table, GeoParquetSchema schema) {
        List<DataColumn> columns = GeoParquetTypeConversion.asDataColumns(schema);
        return new DataSchemaImpl(table, columns);
    }

    private static List<DataColumn> asDataColumns(GeoParquetSchema field) {
        return field.fields().stream().map(GeoParquetTypeConversion::asDataColumn).toList();
    }

    private static DataColumn asDataColumn(GeoParquetSchema.Field field) {
        DataColumn.Cardinality cardinality = switch (field.cardinality()) {
            default -> throw new IncompatibleClassChangeError();
            case GeoParquetSchema.Cardinality.REQUIRED -> DataColumn.Cardinality.REQUIRED;
            case GeoParquetSchema.Cardinality.OPTIONAL -> DataColumn.Cardinality.OPTIONAL;
            case GeoParquetSchema.Cardinality.REPEATED -> DataColumn.Cardinality.REPEATED;
        };
        return switch (field.type()) {
            default -> throw new IncompatibleClassChangeError();
            case GeoParquetSchema.Type.BINARY -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.BINARY);
            case GeoParquetSchema.Type.BOOLEAN -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.BOOLEAN);
            case GeoParquetSchema.Type.INTEGER -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.INTEGER);
            case GeoParquetSchema.Type.INT96, GeoParquetSchema.Type.LONG -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.LONG);
            case GeoParquetSchema.Type.FLOAT -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.FLOAT);
            case GeoParquetSchema.Type.DOUBLE -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.DOUBLE);
            case GeoParquetSchema.Type.STRING -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.STRING);
            case GeoParquetSchema.Type.GEOMETRY -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.GEOMETRY);
            case GeoParquetSchema.Type.ENVELOPE -> new DataColumnFixed(field.name(), cardinality, DataColumn.Type.ENVELOPE);
            case GeoParquetSchema.Type.GROUP -> new DataColumnNested(field.name(), cardinality, GeoParquetTypeConversion.asDataColumns(((GeoParquetSchema.GroupField)field).schema()));
        };
    }

    public static List<Object> asRowValues(GeoParquetGroup group) {
        GeoParquetSchema schema = group.getGeoParquetSchema();
        List<GeoParquetSchema.Field> fields = schema.fields();
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < fields.size(); ++i) {
            GeoParquetSchema.Field field = fields.get(i);
            values.add(GeoParquetTypeConversion.asValue(field, group, i));
        }
        return values;
    }

    public static Map<String, Object> asNested(GeoParquetGroup group) {
        HashMap<String, Object> nested = new HashMap<String, Object>();
        GeoParquetSchema schema = group.getGeoParquetSchema();
        List<GeoParquetSchema.Field> fields = schema.fields();
        for (int i = 0; i < fields.size(); ++i) {
            if (group.getValues(i).isEmpty()) continue;
            GeoParquetSchema.Field field = fields.get(i);
            Object value = GeoParquetTypeConversion.asValue(field, group, i);
            nested.put(field.name(), value);
        }
        return nested;
    }

    public static Object asValue(GeoParquetSchema.Field field, GeoParquetGroup group, int i) {
        if (field.cardinality() == GeoParquetSchema.Cardinality.REPEATED) {
            return switch (field.type()) {
                default -> throw new IncompatibleClassChangeError();
                case GeoParquetSchema.Type.BINARY -> group.getBinaryValues(i).stream().map(Binary::getBytes).toList();
                case GeoParquetSchema.Type.BOOLEAN -> group.getBooleanValues(i);
                case GeoParquetSchema.Type.INTEGER -> group.getIntegerValues(i);
                case GeoParquetSchema.Type.INT96, GeoParquetSchema.Type.LONG -> group.getLongValues(i);
                case GeoParquetSchema.Type.FLOAT -> group.getFloatValues(i);
                case GeoParquetSchema.Type.DOUBLE -> group.getDoubleValues(i);
                case GeoParquetSchema.Type.STRING -> group.getStringValues(i);
                case GeoParquetSchema.Type.GEOMETRY -> group.getGeometryValues(i);
                case GeoParquetSchema.Type.ENVELOPE -> group.getEnvelopeValues(i);
                case GeoParquetSchema.Type.GROUP -> group.getGroupValues(i).stream().map(GeoParquetTypeConversion::asNested).toList();
            };
        }
        return switch (field.type()) {
            default -> throw new IncompatibleClassChangeError();
            case GeoParquetSchema.Type.BINARY -> (Map<String, Object>)group.getBinaryValue(i).getBytes();
            case GeoParquetSchema.Type.BOOLEAN -> group.getBooleanValue(i);
            case GeoParquetSchema.Type.INTEGER -> group.getIntegerValue(i);
            case GeoParquetSchema.Type.INT96, GeoParquetSchema.Type.LONG -> group.getLongValue(i);
            case GeoParquetSchema.Type.FLOAT -> group.getFloatValue(i);
            case GeoParquetSchema.Type.DOUBLE -> group.getDoubleValue(i);
            case GeoParquetSchema.Type.STRING -> group.getStringValue(i);
            case GeoParquetSchema.Type.GEOMETRY -> group.getGeometryValue(i);
            case GeoParquetSchema.Type.ENVELOPE -> group.getEnvelopeValue(i);
            case GeoParquetSchema.Type.GROUP -> GeoParquetTypeConversion.asNested(group.getGroupValue(i));
        };
    }
}

