/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.LogRecord;
import javax.sql.DataSource;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.metadata.sql.util.Dialect;
import org.apache.sis.metadata.sql.util.SQLBuilder;
import org.apache.sis.metadata.sql.util.Syntax;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.FeatureNaming;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.BinaryEncoding;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.GeometryGetter;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.storage.sql.feature.SelectionClauseWriter;
import org.apache.sis.storage.sql.feature.Table;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.storage.sql.postgis.Postgres;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.FrequencySortedSet;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;

public class Database<G>
extends Syntax {
    public static final String WILDCARD = "%";
    protected final DataSource source;
    final Geometries<G> geomLibrary;
    private final boolean isByteSigned;
    private final FeatureNaming<Table> tablesByNames;
    private Table[] tables;
    private boolean isSpatial;
    private boolean hasGeometry;
    private boolean hasRaster;
    String catalogOfSpatialTables;
    String schemaOfSpatialTables;
    final boolean supportsCatalogs;
    final boolean supportsSchemas;
    private final boolean supportsJavaTime;
    private SelectionClauseWriter filterToSQL;
    public final StoreListeners listeners;
    final Cache<Integer, CoordinateReferenceSystem> cacheOfCRS;
    final WeakHashMap<CoordinateReferenceSystem, Integer> cacheOfSRID;

    protected Database(DataSource source, DatabaseMetaData metadata, Dialect dialect, Geometries<G> geomLibrary, StoreListeners listeners) throws SQLException {
        super(metadata, true);
        boolean unsigned = true;
        boolean wasNull = false;
        SQLFeatureNotSupportedException cause = null;
        try (ResultSet reflect = metadata.getTypeInfo();){
            while (reflect.next()) {
                if (reflect.getInt("DATA_TYPE") != -6) continue;
                unsigned = reflect.getBoolean("UNSIGNED_ATTRIBUTE");
                wasNull = reflect.wasNull();
                unsigned |= wasNull;
                if (wasNull) continue;
                break;
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            cause = e;
        }
        if (cause != null || wasNull) {
            listeners.warning(Resources.forLocale(listeners.getLocale()).getString((short)16), (Exception)cause);
        }
        this.source = source;
        this.isByteSigned = !unsigned;
        this.geomLibrary = geomLibrary;
        this.listeners = listeners;
        this.cacheOfCRS = new Cache(7, 2L, false);
        this.cacheOfSRID = new WeakHashMap();
        this.tablesByNames = new FeatureNaming();
        this.supportsCatalogs = metadata.supportsCatalogsInDataManipulation();
        this.supportsSchemas = metadata.supportsSchemasInDataManipulation();
        this.supportsJavaTime = dialect.supportsJavaTime;
    }

    public static Database<?> create(SQLStore store, DataSource source, Connection connection, GeometryLibrary geomLibrary, GenericName[] tableNames, ResourceDefinition[] queries, SchemaModifier customizer, StoreListeners listeners) throws Exception {
        Database db;
        DatabaseMetaData metadata = connection.getMetaData();
        Geometries g = Geometries.factory((GeometryLibrary)geomLibrary);
        Dialect dialect = Dialect.guess((DatabaseMetaData)metadata);
        switch (dialect) {
            case POSTGRESQL: {
                db = new Postgres(source, connection, metadata, dialect, g, listeners);
                break;
            }
            default: {
                db = new Database(source, metadata, dialect, g, listeners);
            }
        }
        db.analyze(store, connection, tableNames, queries, customizer);
        return db;
    }

    private void analyze(SQLStore store, Connection connection, GenericName[] tableNames, ResourceDefinition[] queries, SchemaModifier customizer) throws Exception {
        DatabaseMetaData metadata = connection.getMetaData();
        String[] tableTypes = Database.getTableTypes(metadata);
        String tableCRS = "SPATIAL_REF_SYS";
        String tableGeom = "GEOMETRY_COLUMNS";
        if (metadata.storesLowerCaseIdentifiers()) {
            tableCRS = tableCRS.toLowerCase(Locale.US).intern();
            tableGeom = tableGeom.toLowerCase(Locale.US).intern();
        }
        HashMap<String, Boolean> ignoredTables = new HashMap<String, Boolean>(8);
        ignoredTables.put(tableCRS, Boolean.TRUE);
        ignoredTables.put(tableGeom, Boolean.TRUE);
        this.addIgnoredTables(ignoredTables);
        this.isSpatial = this.hasTable(metadata, tableTypes, ignoredTables);
        Analyzer analyzer = new Analyzer(this, connection, metadata, customizer);
        LinkedHashSet<TableReference> declared = new LinkedHashSet<TableReference>();
        for (GenericName tableName : tableNames) {
            String[] names = TableReference.splitName(tableName);
            try (ResultSet reflect = metadata.getTables(names[2], names[1], names[0], tableTypes);){
                while (reflect.next()) {
                    String table = analyzer.getUniqueString(reflect, "TABLE_NAME");
                    if (ignoredTables.containsKey(table)) continue;
                    declared.add(new TableReference(analyzer.getUniqueString(reflect, "TABLE_CAT"), analyzer.getUniqueString(reflect, "TABLE_SCHEM"), table, analyzer.getUniqueString(reflect, "REMARKS")));
                }
            }
        }
        ArrayList<Table> tableList = new ArrayList<Table>(tableNames.length);
        for (TableReference reference : declared) {
            tableList.add(analyzer.table(reference, reference.getName(analyzer), null));
        }
        for (ResourceDefinition resource : queries) {
            tableList.add(analyzer.query(resource.getName(), resource.getQuery().get()));
        }
        for (Table table : analyzer.finish()) {
            this.tablesByNames.add((DataStore)store, table.featureType.getName(), (Object)table);
            this.hasGeometry |= table.hasGeometry;
            this.hasRaster |= table.hasRaster;
        }
        this.tables = (Table[])tableList.toArray(Table[]::new);
    }

    private static String[] getTableTypes(DatabaseMetaData metadata) throws SQLException {
        HashSet<String> types = new HashSet<String>(4);
        try (ResultSet reflect = metadata.getTableTypes();){
            while (reflect.next()) {
                String type = reflect.getString("TABLE_TYPE");
                if (!"TABLE".equalsIgnoreCase(type) && !"VIEW".equalsIgnoreCase(type) && !"BASE TABLE".equalsIgnoreCase(type)) continue;
                types.add(type);
            }
        }
        return (String[])types.toArray(String[]::new);
    }

    private boolean hasTable(DatabaseMetaData metadata, String[] tableTypes, Map<String, Boolean> tables) throws SQLException {
        FrequencySortedSet schemas = new FrequencySortedSet(true);
        int count = 0;
        for (Map.Entry<String, Boolean> entry : tables.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            String name = entry.getKey();
            boolean found = false;
            try (ResultSet reflect = metadata.getTables(null, null, name, tableTypes);){
                while (reflect.next()) {
                    found = true;
                    schemas.add(new AbstractMap.SimpleImmutableEntry<String, String>(reflect.getString("TABLE_CAT"), reflect.getString("TABLE_SCHEM")));
                }
            }
            if (!found) continue;
            ++count;
        }
        if (count == 0) {
            return false;
        }
        AbstractMap.SimpleImmutableEntry f = (AbstractMap.SimpleImmutableEntry)schemas.first();
        if (schemas.frequency((Object)f) == count) {
            this.catalogOfSpatialTables = (String)f.getKey();
            this.schemaOfSpatialTables = (String)f.getValue();
        }
        return true;
    }

    public final void listTables(DatabaseMetaData metadata, MetadataBuilder builder) throws SQLException {
        for (Table table : this.tables) {
            builder.addFeatureType(table.featureType, table.countRows(metadata, false, false));
        }
    }

    public final List<FeatureSet> tables() {
        return UnmodifiableArrayList.wrap((Object[])this.tables);
    }

    public final FeatureSet findTable(SQLStore store, String name) throws IllegalNameException {
        return (FeatureSet)this.tablesByNames.get((DataStore)store, name);
    }

    public final void appendFunctionCall(SQLBuilder sql, String function) {
        String schema = this.schemaOfSpatialTables;
        if (schema != null && !schema.isEmpty()) {
            String catalog = this.catalogOfSpatialTables;
            if (catalog != null && !catalog.isEmpty()) {
                sql.appendIdentifier(catalog).append('.');
            }
            sql.appendIdentifier(schema).append('.');
        }
        sql.append(function);
    }

    public final boolean isSpatial() {
        return this.isSpatial;
    }

    public final boolean hasGeometry() {
        return this.hasGeometry;
    }

    public final boolean hasRaster() {
        return this.hasRaster;
    }

    protected ValueGetter<?> getMapping(Column columnDefinition) {
        if ("geometry".equalsIgnoreCase(columnDefinition.typeName)) {
            return this.forGeometry(columnDefinition);
        }
        switch (columnDefinition.type) {
            case -7: 
            case 16: {
                return ValueGetter.AsBoolean.INSTANCE;
            }
            case -6: {
                if (this.isByteSigned) {
                    return ValueGetter.AsByte.INSTANCE;
                }
            }
            case 5: {
                return ValueGetter.AsShort.INSTANCE;
            }
            case 4: {
                return ValueGetter.AsInteger.INSTANCE;
            }
            case -5: {
                return ValueGetter.AsLong.INSTANCE;
            }
            case 7: {
                return ValueGetter.AsFloat.INSTANCE;
            }
            case 6: 
            case 8: {
                return ValueGetter.AsDouble.INSTANCE;
            }
            case 2: 
            case 3: {
                return ValueGetter.AsBigDecimal.INSTANCE;
            }
            case -1: 
            case 1: 
            case 12: {
                return ValueGetter.AsString.INSTANCE;
            }
            case 91: {
                return this.supportsJavaTime ? ValueGetter.LOCAL_DATE : ValueGetter.AsLocalDate.INSTANCE;
            }
            case 92: {
                return this.supportsJavaTime ? ValueGetter.LOCAL_TIME : ValueGetter.AsLocalTime.INSTANCE;
            }
            case 93: {
                return this.supportsJavaTime ? ValueGetter.LOCAL_DATE_TIME : ValueGetter.AsLocalDateTime.INSTANCE;
            }
            case 2013: {
                return this.supportsJavaTime ? ValueGetter.OFFSET_TIME : ValueGetter.AsOffsetTime.INSTANCE;
            }
            case 2014: {
                return this.supportsJavaTime ? ValueGetter.OFFSET_DATE_TIME : ValueGetter.AsOffsetDateTime.INSTANCE;
            }
            case 2004: {
                return ValueGetter.AsBytes.INSTANCE;
            }
            case 1111: 
            case 2000: {
                return this.getDefaultMapping();
            }
            case -4: 
            case -3: 
            case -2: {
                BinaryEncoding encoding = this.getBinaryEncoding(columnDefinition);
                switch (encoding) {
                    case RAW: {
                        return ValueGetter.AsBytes.INSTANCE;
                    }
                    case HEXADECIMAL: {
                        return ValueGetter.AsBytes.HEXADECIMAL;
                    }
                }
                throw new AssertionError((Object)encoding);
            }
            case 2003: {
                int componentType = this.getArrayComponentType(columnDefinition);
                ValueGetter<?> component = this.getMapping(new Column(componentType, columnDefinition.typeName));
                if (component == ValueGetter.AsObject.INSTANCE) {
                    return ValueGetter.AsArray.INSTANCE;
                }
                return new ValueGetter.AsArray(component);
            }
        }
        return null;
    }

    protected int getArrayComponentType(Column columnDefinition) {
        return 1111;
    }

    protected ValueGetter<Object> getDefaultMapping() {
        return ValueGetter.AsObject.INSTANCE;
    }

    protected BinaryEncoding getBinaryEncoding(Column columnDefinition) {
        return BinaryEncoding.RAW;
    }

    protected Envelope getEstimatedExtent(TableReference table, Column[] columns, boolean recall) throws SQLException {
        return null;
    }

    protected final ValueGetter<?> forGeometry(Column columnDefinition) {
        GeometryType type = columnDefinition.getGeometryType().orElse(GeometryType.GEOMETRY);
        Class geometryClass = this.geomLibrary.getGeometryClass(type).asSubclass(this.geomLibrary.rootClass);
        return new GeometryGetter(this.geomLibrary, geometryClass, columnDefinition.getDefaultCRS().orElse(null), this.getBinaryEncoding(columnDefinition));
    }

    protected InfoStatements createInfoStatements(Connection connection) {
        return new InfoStatements(this, connection);
    }

    protected void addIgnoredTables(Map<String, Boolean> ignoredTables) {
    }

    protected SelectionClauseWriter getFilterToSQL() {
        return SelectionClauseWriter.DEFAULT;
    }

    final synchronized SelectionClauseWriter getFilterToSupportedSQL() {
        if (this.filterToSQL == null) {
            this.filterToSQL = this.getFilterToSQL().removeUnsupportedFunctions(this);
        }
        return this.filterToSQL;
    }

    protected final void log(LogRecord record) {
        record.setSourceClassName(SQLStore.class.getName());
        record.setSourceMethodName("components");
        record.setLoggerName("org.apache.sis.sql");
        this.listeners.warning(record);
    }

    final void appendTo(TreeTable.Node parent) {
        for (Table child : this.tables) {
            child.appendTo(parent);
        }
    }

    public String toString() {
        return TableReference.toString((Object)this, n -> this.appendTo((TreeTable.Node)n));
    }
}

