/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.internal;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Locale;
import javax.measure.IncommensurableException;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.CoverageCombiner;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.storage.ResourceAlreadyExistsException;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class WritableResourceSupport
implements Localized {
    private final GridCoverageResource resource;
    private boolean replace;
    private boolean update;

    public WritableResourceSupport(GridCoverageResource resource, WritableGridCoverageResource.Option[] options) {
        this.resource = resource;
        ArgumentChecks.ensureNonNull((String)"options", (Object)options);
        for (WritableGridCoverageResource.Option option : options) {
            this.replace |= WritableGridCoverageResource.CommonOption.REPLACE.equals(option);
            this.update |= WritableGridCoverageResource.CommonOption.UPDATE.equals(option);
        }
        if (this.replace & this.update) {
            throw new IllegalArgumentException(Errors.format((short)91, (Object)WritableGridCoverageResource.CommonOption.REPLACE, (Object)WritableGridCoverageResource.CommonOption.UPDATE));
        }
    }

    public final Locale getLocale() {
        return this.resource instanceof Localized ? ((Localized)this.resource).getLocale() : null;
    }

    public final ChannelDataOutput channel(ChannelDataInput input) throws IOException, DataStoreException {
        if (input.channel instanceof WritableByteChannel && input.rewind()) {
            return new ChannelDataOutput(input.filename, (WritableByteChannel)((Object)input.channel), input.buffer);
        }
        throw new ReadOnlyStorageException(this.canNotWrite());
    }

    public final boolean replace(ChannelDataInput input) throws IOException, DataStoreException {
        if (this.update) {
            return WritableResourceSupport.isEmpty(input);
        }
        if (this.replace || WritableResourceSupport.isEmpty(input)) {
            return true;
        }
        String identifier = this.resource.getIdentifier().orElse(null);
        if (identifier == null && input != null) {
            identifier = input.filename;
        }
        throw new ResourceAlreadyExistsException(Resources.forLocale(this.getLocale()).getString((short)48, identifier));
    }

    private static boolean isEmpty(ChannelDataInput input) throws IOException {
        return input != null && input.length() == 0L;
    }

    public final GridCoverage update(GridCoverage coverage) throws DataStoreException {
        GridCoverage existing = this.resource.read(null, null);
        CoverageCombiner combiner = new CoverageCombiner(existing);
        try {
            if (!combiner.acceptAll(new GridCoverage[]{coverage})) {
                throw new ReadOnlyStorageException(this.canNotWrite());
            }
        }
        catch (IncommensurableException | TransformException e) {
            throw new DataStoreReferencingException(this.canNotWrite(), e);
        }
        return existing;
    }

    public final AffineTransform getAffineTransform2D(GridExtent extent, MathTransform gridToCRS) throws DataStoreException {
        TransformSeparator s = new TransformSeparator(gridToCRS);
        try {
            s.addSourceDimensions(extent.getSubspaceDimensions(2));
            return AffineTransforms2D.castOrCopy((MathTransform)s.separate());
        }
        catch (CannotEvaluateException | FactoryException e) {
            throw new DataStoreReferencingException(this.canNotWrite(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IncompatibleResourceException(this.canNotWrite(), e);
        }
    }

    public final String canNotWrite() throws DataStoreException {
        String identifier = this.resource.getIdentifier().orElse(null);
        if (identifier == null) {
            identifier = Classes.getShortClassName((Object)this.resource);
        }
        return Resources.forLocale(this.getLocale()).getString((short)69, identifier);
    }

    public final String rotationNotSupported(String format) {
        return Resources.forLocale(this.getLocale()).getString((short)70, format);
    }
}

