/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.MathTransform;

public final class WKTKeywords
extends Static {
    public static final String Id = "Id";
    public static final String URI = "URI";
    public static final String Citation = "Citation";
    public static final String Authority = "Authority";
    public static final String Anchor = "Anchor";
    public static final String Usage = "Usage";
    public static final String Scope = "Scope";
    public static final String Area = "Area";
    public static final String Remark = "Remark";
    public static final String Unit = "Unit";
    public static final String LengthUnit = "LengthUnit";
    public static final String AngleUnit = "AngleUnit";
    public static final String ScaleUnit = "ScaleUnit";
    public static final String TimeUnit = "TimeUnit";
    public static final String ParametricUnit = "ParametricUnit";
    public static final String CS = "CS";
    public static final String Axis = "Axis";
    public static final String Order = "Order";
    public static final String Meridian = "Meridian";
    public static final String PrimeMeridian = "PrimeMeridian";
    public static final String PrimeM = "PrimeM";
    public static final String Ellipsoid = "Ellipsoid";
    public static final String Spheroid = "Spheroid";
    public static final String ToWGS84 = "ToWGS84";
    public static final String BBox = "BBox";
    public static final String Datum = "Datum";
    public static final String GeodeticDatum = "GeodeticDatum";
    public static final String GeodeticCRS = "GeodeticCRS";
    public static final String BaseGeodCRS = "BaseGeodCRS";
    public static final String GeodCRS = "GeodCRS";
    public static final String GeogCS = "GeogCS";
    public static final String GeocCS = "GeocCS";
    public static final String VerticalExtent = "VerticalExtent";
    public static final String VerticalDatum = "VerticalDatum";
    public static final String VerticalCRS = "VerticalCRS";
    public static final String BaseVertCRS = "BaseVertCRS";
    public static final String VDatum = "VDatum";
    public static final String Vert_Datum = "Vert_Datum";
    public static final String VertCRS = "VertCRS";
    public static final String Vert_CS = "Vert_CS";
    public static final String TimeExtent = "TimeExtent";
    public static final String TimeOrigin = "TimeOrigin";
    public static final String TimeDatum = "TimeDatum";
    public static final String TDatum = "TDatum";
    public static final String TimeCRS = "TimeCRS";
    public static final String BaseTimeCRS = "BaseTimeCRS";
    public static final String ParametricDatum = "ParametricDatum";
    public static final String PDatum = "PDatum";
    public static final String ParametricCRS = "ParametricCRS";
    public static final String BaseParamCRS = "BaseParamCRS";
    public static final String ImageDatum = "ImageDatum";
    public static final String ImageCRS = "ImageCRS";
    public static final String IDatum = "IDatum";
    public static final String EngineeringDatum = "EngineeringDatum";
    public static final String EngineeringCRS = "EngineeringCRS";
    public static final String BaseEngCRS = "BaseEngCRS";
    public static final String EngCRS = "EngCRS";
    public static final String EDatum = "EDatum";
    public static final String Local_Datum = "Local_Datum";
    public static final String Local_CS = "Local_CS";
    public static final String CompoundCRS = "CompoundCRS";
    public static final String Compd_CS = "Compd_CS";
    public static final String ProjectedCRS = "ProjectedCRS";
    public static final String BaseProjCRS = "BaseProjCRS";
    public static final String ProjCRS = "ProjCRS";
    public static final String ProjCS = "ProjCS";
    public static final String BoundCRS = "BoundCRS";
    public static final String Method = "Method";
    public static final String Formula = "Formula";
    public static final String Projection = "Projection";
    public static final String Conversion = "Conversion";
    public static final String DerivingConversion = "DerivingConversion";
    public static final String CoordinateOperation = "CoordinateOperation";
    public static final String OperationAccuracy = "OperationAccuracy";
    public static final String SourceCRS = "SourceCRS";
    public static final String TargetCRS = "TargetCRS";
    public static final String InterpolationCRS = "InterpolationCRS";
    public static final String Parameter = "Parameter";
    public static final String ParameterFile = "ParameterFile";
    public static final String ParameterGroup = "ParameterGroup";
    public static final String GeogTran = "GeogTran";
    public static final String Param_MT = "Param_MT";
    public static final String Inverse_MT = "Inverse_MT";
    public static final String Concat_MT = "Concat_MT";
    public static final String PassThrough_MT = "PassThrough_MT";
    public static final String Fitted_CS = "Fitted_CS";
    public static final String affine = "affine";
    public static final String Cartesian = "Cartesian";
    public static final String cylindrical = "cylindrical";
    public static final String ellipsoidal = "ellipsoidal";
    public static final String linear = "linear";
    public static final String parametric = "parametric";
    public static final String polar = "polar";
    public static final String spherical = "spherical";
    public static final String temporal = "temporal";
    public static final String vertical = "vertical";
    public static final String Point = "Point";
    private static final Map<Class<?>, String[]> TYPES = new HashMap(30);

    private WKTKeywords() {
    }

    private static String[] addType(Class<?> type, String ... keywords) {
        if (TYPES.put(type, keywords) != null) {
            throw new AssertionError(type);
        }
        return keywords;
    }

    public static String[] forType(Class<?> type) {
        return TYPES.get(type);
    }

    static {
        WKTKeywords.addType(GeocentricCRS.class, GeodeticCRS, GeodCRS, GeocCS);
        WKTKeywords.addType(GeographicCRS.class, GeodeticCRS, GeodCRS, GeogCS);
        Object[][] subtypes = new String[][]{WKTKeywords.addType(GeodeticCRS.class, GeodeticCRS, GeodCRS, GeocCS, GeogCS), WKTKeywords.addType(ProjectedCRS.class, ProjectedCRS, ProjCRS, ProjCS), WKTKeywords.addType(VerticalCRS.class, VerticalCRS, VertCRS, Vert_CS), WKTKeywords.addType(EngineeringCRS.class, EngineeringCRS, EngCRS, Local_CS), WKTKeywords.addType(DerivedCRS.class, Fitted_CS), WKTKeywords.addType(TemporalCRS.class, TimeCRS)};
        subtypes = new String[][]{WKTKeywords.addType(SingleCRS.class, (String[])ArraysExt.concatenate((Object[][])subtypes)), WKTKeywords.addType(CompoundCRS.class, CompoundCRS, Compd_CS)};
        WKTKeywords.addType(CoordinateReferenceSystem.class, (String[])ArraysExt.concatenate((Object[][])subtypes));
        subtypes = new String[][]{WKTKeywords.addType(GeodeticDatum.class, GeodeticDatum, Datum), WKTKeywords.addType(TemporalDatum.class, TimeDatum, TDatum), WKTKeywords.addType(VerticalDatum.class, VerticalDatum, VDatum, Vert_Datum), WKTKeywords.addType(EngineeringDatum.class, EngineeringDatum, EDatum, Local_Datum)};
        WKTKeywords.addType(Datum.class, (String[])ArraysExt.concatenate((Object[][])subtypes));
        WKTKeywords.addType(Ellipsoid.class, Ellipsoid, Spheroid);
        WKTKeywords.addType(PrimeMeridian.class, PrimeMeridian, PrimeM);
        WKTKeywords.addType(CoordinateSystemAxis.class, Axis);
        WKTKeywords.addType(BursaWolfParameters.class, ToWGS84);
        WKTKeywords.addType(MathTransform.class, Param_MT, Concat_MT, Inverse_MT, PassThrough_MT);
        WKTKeywords.addType(DirectPosition.class, Point);
    }
}

