/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.provider.Description;
import org.apache.sis.referencing.operation.provider.ESRI;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.operation.Projection;

@XmlTransient
public class SatelliteTracking
extends MapProjection {
    private static final long serialVersionUID = -2406880538621713953L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = ESRI.CENTRAL_MERIDIAN;
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = ESRI.LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_1 = ESRI.STANDARD_PARALLEL_1;
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_2 = ESRI.STANDARD_PARALLEL_2;
    public static final ParameterDescriptor<Double> SATELLITE_ORBIT_INCLINATION;
    public static final ParameterDescriptor<Double> SATELLITE_ORBITAL_PERIOD;
    public static final ParameterDescriptor<Double> ASCENDING_NODE_PERIOD;
    private static final ParameterDescriptorGroup PARAMETERS;

    public SatelliteTracking() {
        super(Projection.class, PARAMETERS);
    }

    private static ParameterBuilder setNameAndDescription(ParameterBuilder builder, String name) {
        return (ParameterBuilder)((ParameterBuilder)builder.addName(name)).setDescription((CharSequence)((Object)new Description(name)));
    }

    @Override
    protected NormalizedProjection createProjection(Parameters parameters) throws ParameterNotFoundException {
        return new org.apache.sis.referencing.operation.projection.SatelliteTracking(this, parameters);
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)SatelliteTracking.builder().setCodeSpace(Citations.SIS, "SIS");
        SATELLITE_ORBIT_INCLINATION = SatelliteTracking.setNameAndDescription(builder, "satellite_orbit_inclination").create(0.0, Units.DEGREE);
        SATELLITE_ORBITAL_PERIOD = SatelliteTracking.setNameAndDescription(builder, "satellite_orbital_period").createStrictlyPositive(Double.NaN, Units.DAY);
        ASCENDING_NODE_PERIOD = SatelliteTracking.setNameAndDescription(builder, "ascending_node_period").createStrictlyPositive(Double.NaN, Units.DAY);
        PARAMETERS = ((ParameterBuilder)builder.addName("Satellite-Tracking")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, SATELLITE_ORBIT_INCLINATION, SATELLITE_ORBITAL_PERIOD, ASCENDING_NODE_PERIOD);
    }
}

