/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.ObjectStreamException;
import java.util.HashMap;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.MatrixParameters;
import org.apache.sis.referencing.operation.provider.EPSGName;
import org.apache.sis.util.internal.CollectionsExt;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.GenericName;

final class MatrixParametersAlphaNum
extends MatrixParameters {
    private static final long serialVersionUID = 476760046257432637L;

    MatrixParametersAlphaNum(ParameterDescriptor<Integer> numRow, ParameterDescriptor<Integer> numCol) {
        super(numRow, numCol);
    }

    @Override
    protected String indicesToName(int[] indices) throws IllegalArgumentException {
        return MatrixParametersAlphaNum.indicesToAlias(indices);
    }

    @Override
    protected ParameterDescriptor<Double> createElementDescriptor(int[] indices) throws IllegalArgumentException {
        if (WKT1 == this) {
            throw new AssertionError();
        }
        ParameterDescriptor wkt = WKT1.getElementDescriptor(indices);
        GenericName name = (GenericName)CollectionsExt.first((Iterable)wkt.getAlias());
        if (name == null) {
            return wkt;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        if (MatrixParametersAlphaNum.isEPSG(indices)) {
            name = EPSGName.create(name.tip().toString());
            int code = (indices[0] == 0 ? 8623 : 8639) + indices[1];
            properties.put("identifiers", EPSGName.identifier(code));
        }
        properties.put("name", name);
        properties.put("alias", wkt.getName());
        return new DefaultParameterDescriptor<Double>(properties, 0, 1, Double.class, null, null, (Double)wkt.getDefaultValue());
    }

    @Override
    Object readResolve() throws ObjectStreamException {
        return this.equals(ALPHANUM) ? ALPHANUM : this;
    }
}

