/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.cors;

import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.armeria.server.annotation.decorator.CorsDecorator;
import com.linecorp.armeria.server.annotation.decorator.CorsDecorators;
import com.linecorp.armeria.server.cors.CorsPolicy;
import com.linecorp.armeria.server.cors.CorsPolicyBuilder;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.cors.CorsServiceBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public final class CorsDecoratorsFactoryFunction
implements DecoratorFactoryFunction<CorsDecorators> {
    @Override
    public Function<? super HttpService, ? extends HttpService> newDecorator(CorsDecorators parameter) {
        CorsDecoratorsFactoryFunction.ensureValidConfig(parameter);
        CorsDecorator[] policies = parameter.value();
        CorsDecorator corsDecorator = policies[0];
        CorsServiceBuilder cb = CorsService.builder(corsDecorator.origins());
        if (parameter.shortCircuit()) {
            cb.shortCircuit();
        }
        cb.firstPolicyBuilder.setConfig(corsDecorator);
        for (int i = 1; i < policies.length; ++i) {
            CorsPolicyBuilder builder = CorsPolicy.builder(policies[i].origins());
            builder.setConfig(policies[i]);
            cb.addPolicy(builder.build());
        }
        Function<? super HttpService, CorsService> decorator = cb.newDecorator();
        return service -> {
            if (service.as(CorsService.class) != null) {
                return service;
            }
            return (HttpService)decorator.apply((HttpService)service);
        };
    }

    private static void ensureValidConfig(CorsDecorators conf) {
        Objects.requireNonNull(conf, "conf");
        CorsDecorator[] policies = conf.value();
        Preconditions.checkState(policies.length > 0, "value() should not be empty.");
        boolean anyOrigin = Arrays.stream(policies).anyMatch(c -> Arrays.asList(c.origins()).contains("*"));
        Preconditions.checkState(!anyOrigin || policies.length == 1 && policies[0].origins().length == 1, "the policy that support any origin (*) has been already included. You cannot have an additional policy or origin.");
        Preconditions.checkState(Arrays.stream(policies).noneMatch(c -> c.origins().length == 0), "origins should not be empty.");
    }
}

