/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.ints;

import com.linecorp.armeria.internal.shaded.fastutil.Size64;
import com.linecorp.armeria.internal.shaded.fastutil.ints.IntIterable;
import com.linecorp.armeria.internal.shaded.fastutil.ints.IntIterator;
import com.linecorp.armeria.internal.shaded.fastutil.ints.IntSpliterator;
import com.linecorp.armeria.internal.shaded.fastutil.ints.IntSpliterators;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface IntCollection
extends IntIterable,
Collection<Integer> {
    @Override
    public IntIterator iterator();

    @Override
    default public IntSpliterator spliterator() {
        return IntSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(int var1);

    public boolean contains(int var1);

    public boolean rem(int var1);

    @Override
    @Deprecated
    default public boolean add(Integer key) {
        return this.add((int)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Integer)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Integer)key);
    }

    public int[] toIntArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Integer> filter) {
        return this.removeIf(filter instanceof IntPredicate ? (IntPredicate)((Object)filter) : key -> filter.test(key));
    }

    default public boolean removeIf(IntPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        IntIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextInt())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public Stream<Integer> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Integer> parallelStream() {
        return Collection.super.parallelStream();
    }
}

