/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

class ArmeriaHttp2Headers
implements Http2Headers {
    private final HttpHeadersBuilder delegate;

    static <T> T unsafeCast(Object obj) {
        return (T)obj;
    }

    ArmeriaHttp2Headers() {
        this(HttpHeaders.builder());
    }

    ArmeriaHttp2Headers(HttpHeadersBuilder delegate) {
        this.delegate = delegate;
    }

    HttpHeadersBuilder delegate() {
        return this.delegate;
    }

    ArmeriaHttp2Headers sizeHint(int sizeHint) {
        this.delegate.sizeHint(sizeHint);
        return this;
    }

    @Nullable
    public CharSequence get(CharSequence name) {
        return this.delegate.get(name);
    }

    public CharSequence get(CharSequence name, CharSequence defaultValue) {
        return MoreObjects.firstNonNull(this.get(name), defaultValue);
    }

    @Nullable
    public CharSequence getAndRemove(CharSequence name) {
        return this.delegate.getAndRemove(name);
    }

    public CharSequence getAndRemove(CharSequence name, CharSequence defaultValue) {
        return MoreObjects.firstNonNull(this.getAndRemove(name), defaultValue);
    }

    public List<CharSequence> getAll(CharSequence name) {
        return (List)ArmeriaHttp2Headers.unsafeCast(this.delegate.getAll(name));
    }

    public List<CharSequence> getAllAndRemove(CharSequence name) {
        return (List)ArmeriaHttp2Headers.unsafeCast(this.delegate.getAllAndRemove(name));
    }

    @Nullable
    public Boolean getBoolean(CharSequence name) {
        return this.delegate.getBoolean(name);
    }

    public boolean getBoolean(CharSequence name, boolean defaultValue) {
        return this.delegate.getBoolean(name, defaultValue);
    }

    @Nullable
    public Byte getByte(CharSequence name) {
        Integer value = this.getInt(name);
        if (value != null) {
            return value.byteValue();
        }
        return null;
    }

    public byte getByte(CharSequence name, byte defaultValue) {
        return MoreObjects.firstNonNull(this.getByte(name), defaultValue);
    }

    @Nullable
    public Character getChar(CharSequence name) {
        Integer value = this.getInt(name);
        if (value != null) {
            return Character.valueOf((char)value.intValue());
        }
        return null;
    }

    public char getChar(CharSequence name, char defaultValue) {
        return MoreObjects.firstNonNull(this.getChar(name), Character.valueOf(defaultValue)).charValue();
    }

    @Nullable
    public Short getShort(CharSequence name) {
        Integer value = this.getInt(name);
        if (value != null) {
            return value.shortValue();
        }
        return null;
    }

    public short getShort(CharSequence name, short defaultValue) {
        return MoreObjects.firstNonNull(this.getShort(name), defaultValue);
    }

    @Nullable
    public Integer getInt(CharSequence name) {
        return this.delegate.getInt(name);
    }

    public int getInt(CharSequence name, int defaultValue) {
        return this.delegate.getInt(name, defaultValue);
    }

    @Nullable
    public Long getLong(CharSequence name) {
        return this.delegate.getLong(name);
    }

    public long getLong(CharSequence name, long defaultValue) {
        return this.delegate.getLong(name, defaultValue);
    }

    @Nullable
    public Float getFloat(CharSequence name) {
        return this.delegate.getFloat(name);
    }

    public float getFloat(CharSequence name, float defaultValue) {
        return this.delegate.getFloat(name, defaultValue);
    }

    @Nullable
    public Double getDouble(CharSequence name) {
        return this.delegate.getDouble(name);
    }

    public double getDouble(CharSequence name, double defaultValue) {
        return this.delegate.getDouble(name, defaultValue);
    }

    @Nullable
    public Long getTimeMillis(CharSequence name) {
        return this.delegate.getTimeMillis(name);
    }

    public long getTimeMillis(CharSequence name, long defaultValue) {
        return this.delegate.getTimeMillis(name, defaultValue);
    }

    @Nullable
    public Boolean getBooleanAndRemove(CharSequence name) {
        String value = this.delegate.getAndRemove(name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public boolean getBooleanAndRemove(CharSequence name, boolean defaultValue) {
        return MoreObjects.firstNonNull(this.getBooleanAndRemove(name), defaultValue);
    }

    @Nullable
    public Byte getByteAndRemove(CharSequence name) {
        Integer value = this.delegate.getIntAndRemove(name);
        if (value != null) {
            return value.byteValue();
        }
        return null;
    }

    public byte getByteAndRemove(CharSequence name, byte defaultValue) {
        return MoreObjects.firstNonNull(this.getByteAndRemove(name), defaultValue);
    }

    @Nullable
    public Character getCharAndRemove(CharSequence name) {
        Integer value = this.delegate.getIntAndRemove(name);
        if (value != null) {
            return Character.valueOf((char)value.intValue());
        }
        return null;
    }

    public char getCharAndRemove(CharSequence name, char defaultValue) {
        return MoreObjects.firstNonNull(this.getCharAndRemove(name), Character.valueOf(defaultValue)).charValue();
    }

    @Nullable
    public Short getShortAndRemove(CharSequence name) {
        Integer value = this.delegate.getIntAndRemove(name);
        if (value != null) {
            return value.shortValue();
        }
        return null;
    }

    public short getShortAndRemove(CharSequence name, short defaultValue) {
        return MoreObjects.firstNonNull(this.getShortAndRemove(name), defaultValue);
    }

    @Nullable
    public Integer getIntAndRemove(CharSequence name) {
        return this.delegate.getIntAndRemove(name);
    }

    public int getIntAndRemove(CharSequence name, int defaultValue) {
        return this.delegate.getIntAndRemove(name, defaultValue);
    }

    @Nullable
    public Long getLongAndRemove(CharSequence name) {
        return this.delegate.getLongAndRemove(name);
    }

    public long getLongAndRemove(CharSequence name, long defaultValue) {
        return this.delegate.getLongAndRemove(name, defaultValue);
    }

    @Nullable
    public Float getFloatAndRemove(CharSequence name) {
        return this.delegate.getFloatAndRemove(name);
    }

    public float getFloatAndRemove(CharSequence name, float defaultValue) {
        return this.delegate.getFloatAndRemove(name, defaultValue);
    }

    @Nullable
    public Double getDoubleAndRemove(CharSequence name) {
        return this.delegate.getDoubleAndRemove(name);
    }

    public double getDoubleAndRemove(CharSequence name, double defaultValue) {
        return this.delegate.getDoubleAndRemove(name, defaultValue);
    }

    @Nullable
    public Long getTimeMillisAndRemove(CharSequence name) {
        return this.delegate.getTimeMillisAndRemove(name);
    }

    public long getTimeMillisAndRemove(CharSequence name, long defaultValue) {
        return this.delegate.getTimeMillisAndRemove(name, defaultValue);
    }

    public boolean contains(CharSequence name) {
        return this.delegate.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.contains(name, value, false);
    }

    public boolean contains(CharSequence name, CharSequence value, boolean caseInsensitive) {
        List<String> values = this.delegate.getAll(name);
        if (values.isEmpty()) {
            return false;
        }
        for (String value0 : values) {
            boolean result = caseInsensitive ? value0.equalsIgnoreCase(value.toString()) : value0.contentEquals(value);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean containsObject(CharSequence name, Object value) {
        return this.delegate.containsObject(name, value);
    }

    public boolean containsBoolean(CharSequence name, boolean value) {
        return this.delegate.containsBoolean(name, value);
    }

    public boolean containsByte(CharSequence name, byte value) {
        Byte byte0 = this.getByte(name);
        if (byte0 == null) {
            return false;
        }
        return byte0 == value;
    }

    public boolean containsChar(CharSequence name, char value) {
        Character char0 = this.getChar(name);
        if (char0 == null) {
            return false;
        }
        return char0.charValue() == value;
    }

    public boolean containsShort(CharSequence name, short value) {
        Short short0 = this.getShort(name);
        if (short0 == null) {
            return false;
        }
        return short0 == value;
    }

    public boolean containsInt(CharSequence name, int value) {
        return this.delegate.containsInt(name, value);
    }

    public boolean containsLong(CharSequence name, long value) {
        return this.delegate.containsLong(name, value);
    }

    public boolean containsFloat(CharSequence name, float value) {
        return this.delegate.containsFloat(name, value);
    }

    public boolean containsDouble(CharSequence name, double value) {
        return this.delegate.containsDouble(name, value);
    }

    public boolean containsTimeMillis(CharSequence name, long value) {
        return this.delegate.containsTimeMillis(name, value);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set<CharSequence> names() {
        return (Set)ArmeriaHttp2Headers.unsafeCast(this.delegate.names());
    }

    public Http2Headers add(CharSequence name, CharSequence value) {
        AsciiString headerName = HttpHeaderNames.of(name);
        this.delegate.add((CharSequence)headerName, ArmeriaHttpUtil.convertHeaderValue(headerName, value));
        return this;
    }

    public Http2Headers add(CharSequence name, Iterable<? extends CharSequence> values) {
        for (CharSequence charSequence : values) {
            this.add(name, charSequence);
        }
        return this;
    }

    public Http2Headers add(CharSequence name, CharSequence ... values) {
        for (CharSequence value : values) {
            this.add(name, value);
        }
        return this;
    }

    public Http2Headers add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        for (Map.Entry header : headers) {
            this.add((CharSequence)header.getKey(), (CharSequence)header.getValue());
        }
        return this;
    }

    public Http2Headers addObject(CharSequence name, Object value) {
        this.delegate.addObject(name, value);
        return this;
    }

    public Http2Headers addObject(CharSequence name, Iterable<?> values) {
        this.delegate.addObject(name, values);
        return this;
    }

    public Http2Headers addObject(CharSequence name, Object ... values) {
        this.delegate.addObject(name, values);
        return this;
    }

    public Http2Headers addBoolean(CharSequence name, boolean value) {
        this.delegate.add(name, String.valueOf(value));
        return this;
    }

    public Http2Headers addByte(CharSequence name, byte value) {
        this.delegate.addInt(name, value);
        return this;
    }

    public Http2Headers addChar(CharSequence name, char value) {
        this.delegate.addInt(name, value);
        return this;
    }

    public Http2Headers addShort(CharSequence name, short value) {
        this.delegate.addInt(name, value);
        return this;
    }

    public Http2Headers addInt(CharSequence name, int value) {
        this.delegate.addInt(name, value);
        return this;
    }

    public Http2Headers addLong(CharSequence name, long value) {
        this.delegate.addLong(name, value);
        return this;
    }

    public Http2Headers addFloat(CharSequence name, float value) {
        this.delegate.addFloat(name, value);
        return this;
    }

    public Http2Headers addDouble(CharSequence name, double value) {
        this.delegate.addDouble(name, value);
        return this;
    }

    public Http2Headers addTimeMillis(CharSequence name, long value) {
        this.delegate.addTimeMillis(name, value);
        return this;
    }

    public Http2Headers set(CharSequence name, CharSequence value) {
        AsciiString headerName = HttpHeaderNames.of(name);
        this.delegate.set((CharSequence)headerName, ArmeriaHttpUtil.convertHeaderValue(headerName, value));
        return this;
    }

    public Http2Headers set(CharSequence name, Iterable<? extends CharSequence> values) {
        for (CharSequence charSequence : values) {
            this.set(name, charSequence);
        }
        return this;
    }

    public Http2Headers set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        if (headers != this) {
            this.clear();
            this.setAll(headers);
        }
        return this;
    }

    public Http2Headers set(CharSequence name, CharSequence ... values) {
        for (CharSequence value : values) {
            this.set(name, value);
        }
        return this;
    }

    public Http2Headers setObject(CharSequence name, Object value) {
        this.delegate.setObject(name, value);
        return this;
    }

    public Http2Headers setObject(CharSequence name, Iterable<?> values) {
        for (Object value : values) {
            this.setObject(name, value);
        }
        return this;
    }

    public Http2Headers setObject(CharSequence name, Object ... values) {
        for (Object value : values) {
            this.setObject(name, value);
        }
        return this;
    }

    public Http2Headers setBoolean(CharSequence name, boolean value) {
        this.delegate.set(name, String.valueOf(value));
        return this;
    }

    public Http2Headers setByte(CharSequence name, byte value) {
        this.delegate.setInt(name, value);
        return this;
    }

    public Http2Headers setChar(CharSequence name, char value) {
        this.delegate.setInt(name, value);
        return this;
    }

    public Http2Headers setShort(CharSequence name, short value) {
        this.delegate.setInt(name, value);
        return this;
    }

    public Http2Headers setInt(CharSequence name, int value) {
        this.delegate.setInt(name, value);
        return this;
    }

    public Http2Headers setLong(CharSequence name, long value) {
        this.delegate.setLong(name, value);
        return this;
    }

    public Http2Headers setFloat(CharSequence name, float value) {
        this.delegate.setFloat(name, value);
        return this;
    }

    public Http2Headers setDouble(CharSequence name, double value) {
        this.delegate.setDouble(name, value);
        return this;
    }

    public Http2Headers setTimeMillis(CharSequence name, long value) {
        this.delegate.setTimeMillis(name, value);
        return this;
    }

    public Http2Headers setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        for (CharSequence name : headers.names()) {
            this.remove(name);
        }
        for (Map.Entry header : headers) {
            this.add((CharSequence)header.getKey(), (CharSequence)header.getValue());
        }
        return this;
    }

    public boolean remove(CharSequence name) {
        return this.delegate.remove(name);
    }

    public Http2Headers clear() {
        this.delegate.clear();
        return this;
    }

    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return (Iterator)ArmeriaHttp2Headers.unsafeCast(this.delegate.iterator());
    }

    public void forEach(Consumer<? super Map.Entry<CharSequence, CharSequence>> action) {
        this.delegate.forEach((? super T entry) -> action.accept((Map.Entry<CharSequence, CharSequence>)ArmeriaHttp2Headers.unsafeCast(entry)));
    }

    public Spliterator<Map.Entry<CharSequence, CharSequence>> spliterator() {
        return (Spliterator)ArmeriaHttp2Headers.unsafeCast(this.delegate.spliterator());
    }

    public Iterator<CharSequence> valueIterator(CharSequence name) {
        return (Iterator)ArmeriaHttp2Headers.unsafeCast(this.delegate.valueIterator(name));
    }

    public Http2Headers method(CharSequence value) {
        return this.set((CharSequence)HttpHeaderNames.METHOD, value);
    }

    @Nullable
    public CharSequence method() {
        return this.delegate.get((CharSequence)HttpHeaderNames.METHOD);
    }

    public Http2Headers scheme(CharSequence value) {
        return this.set((CharSequence)HttpHeaderNames.SCHEME, value);
    }

    @Nullable
    public CharSequence scheme() {
        return this.delegate.get((CharSequence)HttpHeaderNames.SCHEME);
    }

    public Http2Headers authority(CharSequence value) {
        return this.set((CharSequence)HttpHeaderNames.AUTHORITY, value);
    }

    @Nullable
    public CharSequence authority() {
        return this.delegate.get((CharSequence)HttpHeaderNames.AUTHORITY);
    }

    public Http2Headers path(CharSequence value) {
        return this.set((CharSequence)HttpHeaderNames.PATH, value);
    }

    @Nullable
    public CharSequence path() {
        return this.delegate.get((CharSequence)HttpHeaderNames.PATH);
    }

    public Http2Headers status(CharSequence value) {
        return this.set((CharSequence)HttpHeaderNames.STATUS, value);
    }

    @Nullable
    public CharSequence status() {
        return this.delegate.get((CharSequence)HttpHeaderNames.STATUS);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArmeriaHttp2Headers)) {
            return false;
        }
        ArmeriaHttp2Headers that = (ArmeriaHttp2Headers)obj;
        return this.delegate.equals(that.delegate());
    }

    public String toString() {
        return this.delegate.toString();
    }
}

