/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.MediaTypeSet;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.logging.ContentPreviewerFactory;
import com.linecorp.armeria.common.logging.DefaultContentPreviewFactory;
import com.linecorp.armeria.common.logging.PreviewSpec;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class ContentPreviewerFactoryBuilder {
    private static final int DEFAULT_MAX_LENGTH = 32;
    private final ImmutableList.Builder<PreviewSpec> previewSpecsBuilder = ImmutableList.builder();
    private int maxLength = 32;
    private Charset defaultCharset = ArmeriaHttpUtil.HTTP_DEFAULT_CONTENT_CHARSET;

    ContentPreviewerFactoryBuilder() {
    }

    public ContentPreviewerFactoryBuilder maxLength(int maxLength) {
        Preconditions.checkArgument(maxLength > 0, "maxLength : %s (expected: > 0)", maxLength);
        this.maxLength = maxLength;
        return this;
    }

    public ContentPreviewerFactoryBuilder defaultCharset(Charset defaultCharset) {
        this.defaultCharset = Objects.requireNonNull(defaultCharset, "defaultCharset");
        return this;
    }

    public ContentPreviewerFactoryBuilder text(MediaType ... mediaTypes) {
        return this.text(ImmutableList.copyOf(Objects.requireNonNull(mediaTypes, "mediaTypes")));
    }

    public ContentPreviewerFactoryBuilder text(Iterable<MediaType> mediaTypes) {
        this.text(ContentPreviewerFactoryBuilder.previewerPredicate(MediaTypeSet.of(mediaTypes)));
        return this;
    }

    public ContentPreviewerFactoryBuilder text(BiPredicate<? super RequestContext, ? super HttpHeaders> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.previewSpecsBuilder.add((Object)new PreviewSpec(predicate, PreviewSpec.PreviewMode.TEXT, null));
        return this;
    }

    public ContentPreviewerFactoryBuilder binary(MediaType ... mediaTypes) {
        return this.binary(ImmutableList.copyOf(Objects.requireNonNull(mediaTypes, "mediaTypes")));
    }

    public ContentPreviewerFactoryBuilder binary(Iterable<MediaType> mediaTypes) {
        this.binary(ContentPreviewerFactoryBuilder.hexDumpProducer(), mediaTypes);
        return this;
    }

    public ContentPreviewerFactoryBuilder binary(BiFunction<? super HttpHeaders, ? super ByteBuf, String> producer, MediaType ... mediaTypes) {
        return this.binary(producer, ImmutableList.copyOf(Objects.requireNonNull(mediaTypes, "mediaTypes")));
    }

    public ContentPreviewerFactoryBuilder binary(BiFunction<? super HttpHeaders, ? super ByteBuf, String> producer, Iterable<MediaType> mediaTypes) {
        return this.binary(producer, ContentPreviewerFactoryBuilder.previewerPredicate(MediaTypeSet.of(mediaTypes)));
    }

    public ContentPreviewerFactoryBuilder binary(BiPredicate<? super RequestContext, ? super HttpHeaders> predicate) {
        return this.binary(ContentPreviewerFactoryBuilder.hexDumpProducer(), predicate);
    }

    public ContentPreviewerFactoryBuilder binary(BiFunction<? super HttpHeaders, ? super ByteBuf, String> producer, BiPredicate<? super RequestContext, ? super HttpHeaders> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Objects.requireNonNull(producer, "producer");
        this.previewSpecsBuilder.add((Object)new PreviewSpec(predicate, PreviewSpec.PreviewMode.BINARY, producer));
        return this;
    }

    public ContentPreviewerFactoryBuilder disable(MediaType ... mediaTypes) {
        return this.disable(ImmutableList.copyOf(Objects.requireNonNull(mediaTypes, "mediaTypes")));
    }

    public ContentPreviewerFactoryBuilder disable(Iterable<MediaType> mediaTypes) {
        return this.disable(ContentPreviewerFactoryBuilder.previewerPredicate(MediaTypeSet.of(mediaTypes)));
    }

    public ContentPreviewerFactoryBuilder disable(BiPredicate<? super RequestContext, ? super HttpHeaders> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.previewSpecsBuilder.add((Object)new PreviewSpec(predicate, PreviewSpec.PreviewMode.DISABLED, null));
        return this;
    }

    public ContentPreviewerFactory build() {
        return new DefaultContentPreviewFactory((List<PreviewSpec>)((Object)this.previewSpecsBuilder.build()), this.maxLength, this.defaultCharset);
    }

    private static BiPredicate<? super RequestContext, ? super HttpHeaders> previewerPredicate(MediaTypeSet mediaTypeSet) {
        Objects.requireNonNull(mediaTypeSet, "mediaTypesSet");
        return (ctx, headers) -> {
            MediaType contentType = headers.contentType();
            if (contentType == null) {
                return false;
            }
            return mediaTypeSet.match(contentType) != null;
        };
    }

    static BiFunction<? super HttpHeaders, ? super ByteBuf, String> hexDumpProducer() {
        return (headers, byteBuf) -> ByteBufUtil.hexDump((ByteBuf)byteBuf);
    }
}

