/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.rules.SingleValuesOptimizationRules;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SingleValuesOptimizationRules.JoinRightSingleRuleConfig", generator="Immutables")
@Immutable
final class ImmutableJoinRightSingleRuleConfig
implements SingleValuesOptimizationRules.JoinRightSingleRuleConfig {
    private final RelBuilderFactory relBuilderFactory;
    @Nullable
    private final @org.checkerframework.checker.nullness.qual.Nullable String description;
    private final RelRule.OperandTransform operandSupplier;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableJoinRightSingleRuleConfig INSTANCE = ImmutableJoinRightSingleRuleConfig.validate(new ImmutableJoinRightSingleRuleConfig());

    private ImmutableJoinRightSingleRuleConfig() {
        this.description = null;
        this.relBuilderFactory = this.initShim.relBuilderFactory();
        this.operandSupplier = this.initShim.operandSupplier();
        this.initShim = null;
    }

    private ImmutableJoinRightSingleRuleConfig(Builder builder) {
        this.description = builder.description;
        if (builder.relBuilderFactory != null) {
            this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
        }
        if (builder.operandSupplier != null) {
            this.initShim.withOperandSupplier(builder.operandSupplier);
        }
        this.relBuilderFactory = this.initShim.relBuilderFactory();
        this.operandSupplier = this.initShim.operandSupplier();
        this.initShim = null;
    }

    private ImmutableJoinRightSingleRuleConfig(RelBuilderFactory relBuilderFactory, @Nullable @org.checkerframework.checker.nullness.qual.Nullable String description, RelRule.OperandTransform operandSupplier) {
        this.relBuilderFactory = relBuilderFactory;
        this.description = description;
        this.operandSupplier = operandSupplier;
        this.initShim = null;
    }

    private RelBuilderFactory relBuilderFactoryInitialize() {
        return SingleValuesOptimizationRules.JoinRightSingleRuleConfig.super.relBuilderFactory();
    }

    private RelRule.OperandTransform operandSupplierInitialize() {
        return SingleValuesOptimizationRules.JoinRightSingleRuleConfig.super.operandSupplier();
    }

    @Override
    public RelBuilderFactory relBuilderFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
    }

    @Override
    @Nullable
    public @org.checkerframework.checker.nullness.qual.Nullable String description() {
        return this.description;
    }

    @Override
    public RelRule.OperandTransform operandSupplier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.operandSupplier() : this.operandSupplier;
    }

    @Override
    public final ImmutableJoinRightSingleRuleConfig withRelBuilderFactory(RelBuilderFactory value) {
        if (this.relBuilderFactory == value) {
            return this;
        }
        RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
        return ImmutableJoinRightSingleRuleConfig.validate(new ImmutableJoinRightSingleRuleConfig(newValue, this.description, this.operandSupplier));
    }

    @Override
    public final ImmutableJoinRightSingleRuleConfig withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return ImmutableJoinRightSingleRuleConfig.validate(new ImmutableJoinRightSingleRuleConfig(this.relBuilderFactory, value, this.operandSupplier));
    }

    @Override
    public final ImmutableJoinRightSingleRuleConfig withOperandSupplier(RelRule.OperandTransform value) {
        if (this.operandSupplier == value) {
            return this;
        }
        RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
        return ImmutableJoinRightSingleRuleConfig.validate(new ImmutableJoinRightSingleRuleConfig(this.relBuilderFactory, this.description, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJoinRightSingleRuleConfig && this.equalTo((ImmutableJoinRightSingleRuleConfig)another);
    }

    private boolean equalTo(ImmutableJoinRightSingleRuleConfig another) {
        return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relBuilderFactory.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.operandSupplier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JoinRightSingleRuleConfig").omitNullValues().add("relBuilderFactory", (Object)this.relBuilderFactory).add("description", (Object)this.description).add("operandSupplier", (Object)this.operandSupplier).toString();
    }

    public static ImmutableJoinRightSingleRuleConfig of() {
        return INSTANCE;
    }

    private static ImmutableJoinRightSingleRuleConfig validate(ImmutableJoinRightSingleRuleConfig instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static ImmutableJoinRightSingleRuleConfig copyOf(SingleValuesOptimizationRules.JoinRightSingleRuleConfig instance) {
        if (instance instanceof ImmutableJoinRightSingleRuleConfig) {
            return (ImmutableJoinRightSingleRuleConfig)instance;
        }
        return ImmutableJoinRightSingleRuleConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SingleValuesOptimizationRules.JoinRightSingleRuleConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private RelBuilderFactory relBuilderFactory;
        @Nullable
        private @org.checkerframework.checker.nullness.qual.Nullable String description;
        @Nullable
        private RelRule.OperandTransform operandSupplier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RelRule.Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SingleValuesOptimizationRules.JoinRightSingleRuleConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof RelRule.Config) {
                RelRule.Config instance = (RelRule.Config)object;
                this.withRelBuilderFactory(instance.relBuilderFactory());
                this.withOperandSupplier(instance.operandSupplier());
                @org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                if (descriptionValue != null) {
                    this.withDescription(descriptionValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
            this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
            this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
            return this;
        }

        public ImmutableJoinRightSingleRuleConfig build() {
            return ImmutableJoinRightSingleRuleConfig.validate(new ImmutableJoinRightSingleRuleConfig(this));
        }
    }

    @Generated(from="SingleValuesOptimizationRules.JoinRightSingleRuleConfig", generator="Immutables")
    private final class InitShim {
        private byte relBuilderFactoryBuildStage = 0;
        private RelBuilderFactory relBuilderFactory;
        private byte operandSupplierBuildStage = 0;
        private RelRule.OperandTransform operandSupplier;

        private InitShim() {
        }

        RelBuilderFactory relBuilderFactory() {
            if (this.relBuilderFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relBuilderFactoryBuildStage == 0) {
                this.relBuilderFactoryBuildStage = (byte)-1;
                this.relBuilderFactory = Objects.requireNonNull(ImmutableJoinRightSingleRuleConfig.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                this.relBuilderFactoryBuildStage = 1;
            }
            return this.relBuilderFactory;
        }

        void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
            this.relBuilderFactory = relBuilderFactory;
            this.relBuilderFactoryBuildStage = 1;
        }

        RelRule.OperandTransform operandSupplier() {
            if (this.operandSupplierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.operandSupplierBuildStage == 0) {
                this.operandSupplierBuildStage = (byte)-1;
                this.operandSupplier = Objects.requireNonNull(ImmutableJoinRightSingleRuleConfig.this.operandSupplierInitialize(), "operandSupplier");
                this.operandSupplierBuildStage = 1;
            }
            return this.operandSupplier;
        }

        void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
            this.operandSupplier = operandSupplier;
            this.operandSupplierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.relBuilderFactoryBuildStage == -1) {
                attributes.add("relBuilderFactory");
            }
            if (this.operandSupplierBuildStage == -1) {
                attributes.add("operandSupplier");
            }
            return "Cannot build JoinRightSingleRuleConfig, attribute initializers form cycle " + attributes;
        }
    }
}

