/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.LineString;
import mil.nga.sf.Point;
import mil.nga.sf.util.GeometryUtils;
import mil.nga.sf.util.SFException;

public class LinearRing
extends LineString {
    private static final long serialVersionUID = 1L;

    public LinearRing() {
        this(false, false);
    }

    public LinearRing(boolean hasZ, boolean hasM) {
        super(hasZ, hasM);
    }

    public LinearRing(List<Point> points) {
        this(GeometryUtils.hasZ(points), GeometryUtils.hasM(points));
        this.setPoints(points);
    }

    public LinearRing(LinearRing linearRing) {
        this(linearRing.hasZ(), linearRing.hasM());
        for (Point point : linearRing.getPoints()) {
            this.addPoint((Point)point.copy());
        }
    }

    @Override
    public void setPoints(List<Point> points) {
        super.setPoints(points);
        if (!this.isEmpty()) {
            if (!this.isClosed()) {
                this.addPoint(points.get(0));
            }
            if (this.numPoints() < 4) {
                throw new SFException("A closed linear ring must have at least four points.");
            }
        }
    }

    @Override
    public Geometry copy() {
        return new LinearRing(this);
    }
}

