/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.common.stream.FixedStreamMessage;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;

@UnstableApi
public class ThreeElementFixedStreamMessage<T>
extends FixedStreamMessage<T> {
    @Nullable
    private T obj1;
    @Nullable
    private T obj2;
    @Nullable
    private T obj3;
    private boolean inOnNext;
    private volatile int demand;

    public ThreeElementFixedStreamMessage(T obj1, T obj2, T obj3) {
        this.obj1 = obj1;
        this.obj2 = obj2;
        this.obj3 = obj3;
    }

    @Override
    public long demand() {
        return this.demand;
    }

    @Override
    final void cleanupObjects(@Nullable Throwable cause) {
        if (this.obj1 != null) {
            StreamMessageUtil.closeOrAbort(this.obj1, cause);
            this.obj1 = null;
        }
        if (this.obj2 != null) {
            StreamMessageUtil.closeOrAbort(this.obj2, cause);
            this.obj2 = null;
        }
        if (this.obj3 != null) {
            StreamMessageUtil.closeOrAbort(this.obj3, cause);
            this.obj3 = null;
        }
    }

    @Override
    final List<T> drainAll(boolean withPooledObjects) {
        assert (this.obj1 != null);
        ImmutableList<T> objs = ImmutableList.of(StreamMessageUtil.touchOrCopyAndClose(this.obj1, withPooledObjects), StreamMessageUtil.touchOrCopyAndClose(this.obj2, withPooledObjects), StreamMessageUtil.touchOrCopyAndClose(this.obj3, withPooledObjects));
        this.obj3 = null;
        this.obj2 = null;
        this.obj1 = null;
        return objs;
    }

    public void request(long n) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.request0(n);
        } else {
            executor.execute(() -> this.request0(n));
        }
    }

    private void request0(long n) {
        if (this.obj3 == null) {
            return;
        }
        if (n <= 0L) {
            this.onError(new IllegalArgumentException("n: " + n + " (expected: > 0, see Reactive Streams specification rule 3.9)"));
            return;
        }
        if (this.inOnNext) {
            this.demand = n == 1L ? ++this.demand : (this.demand += 2);
            return;
        }
        if (n >= 3L) {
            T item;
            this.inOnNext = true;
            if (this.obj1 != null) {
                item = this.obj1;
                this.obj1 = null;
                this.onNext(item);
            }
            if (this.obj2 != null) {
                item = this.obj2;
                this.obj2 = null;
                this.onNext(item);
            }
            if (this.obj3 != null) {
                item = this.obj3;
                this.obj3 = null;
                this.onNext(item);
                this.onComplete();
            }
        } else {
            T item;
            this.demand = (int)((long)this.demand + n);
            if (this.obj1 != null) {
                item = this.obj1;
                this.obj1 = null;
                this.inOnNext = true;
                this.onNext(item);
                this.inOnNext = false;
                --this.demand;
            }
            if (this.obj2 != null && this.demand > 0) {
                item = this.obj2;
                this.obj2 = null;
                this.inOnNext = true;
                this.onNext(item);
                this.inOnNext = false;
                --this.demand;
            }
            if (this.obj3 != null && this.demand > 0) {
                item = this.obj3;
                this.obj3 = null;
                this.onNext(item);
                this.onComplete();
            }
        }
    }

    @Override
    public void cancel() {
        if (this.obj3 == null) {
            return;
        }
        super.cancel();
    }

    @Override
    public void abort() {
        if (this.obj3 == null) {
            return;
        }
        super.abort();
    }

    @Override
    public void abort(Throwable cause) {
        if (this.obj3 == null) {
            return;
        }
        super.abort(cause);
    }
}

