/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.encoding;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import java.io.IOException;
import java.io.OutputStream;

final class SnappyFramedOutputStream
extends OutputStream {
    private final SimpleSnappyFrameEncoder encoder = new SimpleSnappyFrameEncoder();
    private final ByteBuf out;

    SnappyFramedOutputStream(ByteBuf out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuf input = Unpooled.wrappedBuffer((byte[])b, (int)off, (int)len);
        try {
            this.encoder.encode(input, this.out);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failed to compress input with Snappy framing format:", e);
        }
    }

    private static class SimpleSnappyFrameEncoder
    extends SnappyFrameEncoder {
        private SimpleSnappyFrameEncoder() {
        }

        public void encode(ByteBuf in, ByteBuf out) throws Exception {
            this.encode(null, in, out);
        }
    }
}

