/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.HeaderMaskingFunction;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.netty.util.AsciiString;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

abstract class AbstractHeadersSanitizerBuilder<T> {
    private static final Set<AsciiString> DEFAULT_SENSITIVE_HEADERS = ImmutableSet.of(HttpHeaderNames.AUTHORIZATION, HttpHeaderNames.COOKIE, HttpHeaderNames.SET_COOKIE, HttpHeaderNames.PROXY_AUTHORIZATION);
    @Nullable
    private Set<AsciiString> sensitiveHeaders;
    private HeaderMaskingFunction maskingFunction = HeaderMaskingFunction.of();

    AbstractHeadersSanitizerBuilder() {
    }

    public AbstractHeadersSanitizerBuilder<T> sensitiveHeaders(CharSequence ... headers) {
        Objects.requireNonNull(headers, "headers");
        return this.sensitiveHeaders(ImmutableSet.copyOf(headers));
    }

    public AbstractHeadersSanitizerBuilder<T> sensitiveHeaders(Iterable<? extends CharSequence> headers) {
        Objects.requireNonNull(headers, "headers");
        if (this.sensitiveHeaders == null) {
            this.sensitiveHeaders = new HashSet<AsciiString>();
        }
        headers.forEach(header -> this.sensitiveHeaders.add(AsciiString.of((CharSequence)header).toLowerCase()));
        return this;
    }

    final Set<AsciiString> sensitiveHeaders() {
        if (this.sensitiveHeaders != null) {
            return ImmutableSet.copyOf(this.sensitiveHeaders);
        }
        return DEFAULT_SENSITIVE_HEADERS;
    }

    public AbstractHeadersSanitizerBuilder<T> maskingFunction(HeaderMaskingFunction maskingFunction) {
        this.maskingFunction = Objects.requireNonNull(maskingFunction, "maskingFunction");
        return this;
    }

    final HeaderMaskingFunction maskingFunction() {
        return this.maskingFunction;
    }
}

