/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointWeightTransition;
import com.linecorp.armeria.client.endpoint.WeightRampingUpStrategy;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

@UnstableApi
public final class WeightRampingUpStrategyBuilder {
    static final long DEFAULT_RAMPING_UP_INTERVAL_MILLIS = 2000L;
    static final int DEFAULT_TOTAL_STEPS = 10;
    static final int DEFAULT_RAMPING_UP_TASK_WINDOW_MILLIS = 500;
    static final EndpointWeightTransition defaultTransition = EndpointWeightTransition.linear();
    private EndpointWeightTransition transition = defaultTransition;
    @Nullable
    private EventExecutor executor;
    private long rampingUpIntervalMillis = 2000L;
    private int totalSteps = 10;
    private long rampingUpTaskWindowMillis = 500L;

    public WeightRampingUpStrategyBuilder transition(EndpointWeightTransition transition) {
        this.transition = Objects.requireNonNull(transition, "transition");
        return this;
    }

    public WeightRampingUpStrategyBuilder executor(EventExecutor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
        return this;
    }

    public WeightRampingUpStrategyBuilder rampingUpInterval(Duration rampingUpInterval) {
        Objects.requireNonNull(rampingUpInterval, "rampingUpInterval");
        return this.rampingUpIntervalMillis(rampingUpInterval.toMillis());
    }

    public WeightRampingUpStrategyBuilder rampingUpIntervalMillis(long rampingUpIntervalMillis) {
        Preconditions.checkArgument(rampingUpIntervalMillis > 0L, "rampingUpIntervalMillis: %s (expected: > 0)", rampingUpIntervalMillis);
        this.rampingUpIntervalMillis = rampingUpIntervalMillis;
        return this;
    }

    public WeightRampingUpStrategyBuilder totalSteps(int totalSteps) {
        Preconditions.checkArgument(totalSteps > 0, "totalSteps: %s (expected: > 0)", totalSteps);
        this.totalSteps = totalSteps;
        return this;
    }

    public WeightRampingUpStrategyBuilder rampingUpTaskWindow(Duration rampingUpTaskWindow) {
        Objects.requireNonNull(rampingUpTaskWindow, "rampingUpTaskWindow");
        return this.rampingUpTaskWindowMillis(rampingUpTaskWindow.toMillis());
    }

    public WeightRampingUpStrategyBuilder rampingUpTaskWindowMillis(long rampingUpTaskWindowMillis) {
        Preconditions.checkArgument(rampingUpTaskWindowMillis >= 0L, "rampingUpTaskWindowMillis: %s (expected >= 0)", rampingUpTaskWindowMillis);
        this.rampingUpTaskWindowMillis = rampingUpTaskWindowMillis;
        return this;
    }

    public EndpointSelectionStrategy build() {
        Preconditions.checkState(this.rampingUpIntervalMillis > this.rampingUpTaskWindowMillis, "rampingUpIntervalMillis: %s, rampingUpTaskWindowMillis: %s (expected: rampingUpIntervalMillis > rampingUpTaskWindowMillis)", this.rampingUpIntervalMillis, this.rampingUpTaskWindowMillis);
        Supplier<EventExecutor> executorSupplier = this.executor != null ? () -> this.executor : () -> CommonPools.workerGroup().next();
        return new WeightRampingUpStrategy(this.transition, executorSupplier, this.rampingUpIntervalMillis, this.totalSteps, this.rampingUpTaskWindowMillis);
    }
}

